package utils

///对数据进行加密、解密、验签等方法
import (
	"crypto"
	"crypto/aes"
	"crypto/md5"
	"crypto/rand"
	"crypto/rsa"
	"crypto/sha1"
	"crypto/x509"
	"encoding/base64"
	"encoding/hex"
	"encoding/pem"
	"errors"
	"fmt"

	"software.sslmate.com/src/go-pkcs12"

	//"crypto/pkcs12"
	"io/ioutil"
)

// 对数字进行Sha1加密
func Sha1(data string) string {
	//产生一个散列值得方式是 sha1.New()，sha1.Write(bytes)，然后 sha1.Sum([]byte{})。这里我们从一个新的散列开始。
	h := sha1.New()
	//写入要处理的字节。如果是一个字符串，需要使用[]byte(s) 来强制转换成字节数组。
	h.Write([]byte(data))
	//这个用来得到最终的散列值的字符切片。Sum 的参数可以用来都现有的字符切片追加额外的字节切片：一般不需要要。
	bs := h.Sum(nil)
	hexStr := hex.EncodeToString(bs)
	return hexStr
}

// /根据私钥证书路径和密码对数据进行私钥加密，并返回Base64数据
func Sign(data string, path string, password string) (string, error) {
	var pfxData []byte
	var erro error
	var private *rsa.PrivateKey
	pfxData, err := ioutil.ReadFile(path)
	if err != nil {
		erro = err
	}
	var priv interface{}
	//解析证书
	priv, _, _, err = pkcs12.DecodeChain(pfxData, password)
	if err != nil {
		erro = err
	}
	private = priv.(*rsa.PrivateKey)
	ciphertext, err := hex.DecodeString(data)
	if err != nil {
		erro = err
	}
	hash := md5.New()
	hash.Write(ciphertext)
	hashed := hash.Sum(nil)
	signer, err := rsa.SignPKCS1v15(rand.Reader, private, crypto.MD5, hashed[:])
	if err != nil {
		erro = err
	}
	base64Str := base64.StdEncoding.EncodeToString(signer)
	return base64Str, erro
}

// 根据公钥文件对数据进行加密
func VerifySign(data string, path string, sign string) error {
	var public *rsa.PublicKey
	pubData, err := ioutil.ReadFile(path)
	if err != nil {
		return err
	}
	pub := base64.StdEncoding.EncodeToString(pubData)
	var temp string
	split(pub, &temp)
	public_key := "\n-----BEGIN CERTIFICATE-----\n" + temp + "-----END CERTIFICATE-----\n"
	var publicKey = []byte(public_key)
	block, _ := pem.Decode(publicKey)
	if block == nil {
		return errors.New("public key error")
	}
	var cert *x509.Certificate
	cert, _ = x509.ParseCertificate(block.Bytes)
	public = cert.PublicKey.(*rsa.PublicKey)
	datasign, err := hex.DecodeString(data)
	if err != nil {
		return err
	}
	hash := md5.New()
	hash.Write(datasign)
	hashed := hash.Sum(nil)

	signdata, err := base64.StdEncoding.DecodeString(sign)
	if err != nil {
		return err
	}
	//对Sign验签
	return rsa.VerifyPKCS1v15(public, crypto.MD5, hashed[:], signdata)
}

// 根据公钥文件对数据进行加密
func PublicEncrypt(data string, path string) (string, error) {
	var public *rsa.PublicKey
	var erro error
	pubData, err := ioutil.ReadFile(path)
	if err != nil {
		fmt.Println("perr:", err)
		erro = err
	}
	pub := base64.StdEncoding.EncodeToString(pubData)
	var temp string
	split(pub, &temp)
	public_key := "\n-----BEGIN CERTIFICATE-----\n" + temp + "-----END CERTIFICATE-----\n"
	var publicKey = []byte(public_key)
	block, _ := pem.Decode(publicKey)
	if block == nil {
		erro = errors.New("public key error")
	}
	var cert *x509.Certificate
	cert, _ = x509.ParseCertificate(block.Bytes)
	public = cert.PublicKey.(*rsa.PublicKey)
	dataByte := []byte(data)
	//对明文进行加密
	cipherText, err := rsa.EncryptPKCS1v15(rand.Reader, public, dataByte)
	if err != nil {
		fmt.Println("cherr:", err)
		erro = err
	}
	//返回密文
	base64Str := base64.StdEncoding.EncodeToString(cipherText)
	return base64Str, erro
}

// /根据私钥证书路径和密码对数据进行私钥解密并返回数据
func PrivateDecrypt(data string, path string, password string) (string, error) {
	var pfxData []byte
	var erro error
	var private *rsa.PrivateKey
	pfxData, err := ioutil.ReadFile(path)
	if err != nil {
		erro = err
	}
	var priv interface{}
	//解析证书
	priv, _, _, err = pkcs12.DecodeChain(pfxData, password)
	if err != nil {
		erro = err
	}
	private = priv.(*rsa.PrivateKey)
	ciphertext, err := base64.StdEncoding.DecodeString(data)
	if err != nil {
		erro = err
	}
	reslut, err := rsa.DecryptPKCS1v15(rand.Reader, private, ciphertext)
	if err != nil {
		erro = err
	}
	return string(reslut), erro
}

// AES/ECB/PKCS7模式加密--签名加密方式
func AesECBEncrypt(data string, key string) (string, error) {
	newKey := []byte(key)
	dataByte := []byte(data)
	block, err := aes.NewCipher(newKey)
	if err != nil {
		return "", err
	}
	ecb := NewECBEncryptEr(block)
	// 加PKCS7填充
	content := PKCS7Padding(dataByte, block.BlockSize())
	encryptData := make([]byte, len(content))
	// 生成加密数据
	ecb.CryptBlocks(encryptData, content)
	base64Str := base64.StdEncoding.EncodeToString(encryptData)
	return base64Str, nil
}

// AES/ECB/PKCS7模式解密--签名解密方式
func AesECBDecrypt(data string, key string) (string, error) {
	newKey := []byte(key)
	dataByte, err := base64.StdEncoding.DecodeString(data)
	if err != nil {
		return "", err
	}
	block, err := aes.NewCipher(newKey)
	if err != nil {
		return "", err
	}
	ecb := NewECBDecryptEr(block)
	retData := make([]byte, len(dataByte))
	ecb.CryptBlocks(retData, dataByte)
	// 解PKCS7填充
	retData = PKCS7UnPadding(retData)
	return string(retData), nil
}
