
package com.upay.sdk.onlinepay;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.cashier.order.builder.ReceiptPaymentBuilder;
import com.upay.sdk.cashier.order.executer.ReceiptOrderExecuter;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.ResultListenerAdpater;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;

public class ReceiptPaymentServlet extends HttpServlet {

    static final Logger LOGGER = LoggerFactory.getLogger(ReceiptPaymentServlet.class);
    private static final long serialVersionUID = -5276225897505360096L;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doPost(req, resp);
    }

    @Override
    protected void doPost(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        String merchantId = req.getParameter("merchantId");
        String requestId = req.getParameter("requestId");
        String kaptchaCode = req.getParameter("kaptchaCode");
        String paymentOrderId = req.getParameter("paymentOrderId");

        ReceiptPaymentBuilder builder = new ReceiptPaymentBuilder(merchantId);
        builder.setRequestId(requestId)
                .setPaymentOrderId(paymentOrderId)
                .setKaptchaCode(kaptchaCode);

        final PrintWriter out = resp.getWriter();

        if(StringUtils.isBlank(merchantId)){
            out.println("参数异常</br>");
            out.println("商户编号不能为空");
            return;
        }else{
            if (merchantId.length() != 9){
                out.println("参数异常</br>");
                out.println("商户编号长度必须为9");
                return;
            }
        }

        try {
            ReceiptOrderExecuter executer = new ReceiptOrderExecuter();
            executer.payment(builder, new ResultListenerAdpater() {
                /**
                 * 提交成功，不代表支付成功
                 */
                @Override
                public void success(JSONObject jsonObject) {
                    LOGGER.debug("success jsonObject:[" + jsonObject + "]");
                    out.println("提交成功</br>");
                    out.println(jsonObject);
                }

                @Override
                public void redirect(JSONObject jsonObject, String redirectUrl) throws IOException {
                    resp.sendRedirect(redirectUrl);
                    LOGGER.debug("redirectUrl:[" + redirectUrl + "]");
                }
            });
        } catch (ResponseException e) {
            out.println("响应异常</br>");
            out.println(e.toString());
        } catch (HmacVerifyException e) {
            out.println("签名验证异常</br>");
            out.println(e.toString());
        } catch (RequestException e) {
            out.println("请求异常</br>");
            out.println(e.toString());
        } catch (UnknownException e) {
            out.println("未知异常</br>");
            out.println(e.toString());
        }
    }
}
