
package com.upay.sdk.onlinepay;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.cashier.bindcard.builder.BindCardBuilder;
import com.upay.sdk.cashier.bindcard.executer.BindCardExecuter;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.ResultListenerAdpater;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * 
 * @ClassName: BindCardServlet
 */
public class BindCardServlet extends HttpServlet {

	private static final long serialVersionUID = -1164878700739474259L;

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doPost(req, resp);
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		//商户编号
		String merchantId = req.getParameter("merchantId");
		//商户会员id
		String merchantUserId = req.getParameter("merchantUserId");
		//	银⾏卡号
		String bankCardNumber = req.getParameter("bankCardNumber");
		//预留⼿机号
		String phoneNumber = req.getParameter("phoneNumber");
		//	持卡⼈姓名
		String name = req.getParameter("name");
		//	身份证号
		String idCardNum = req.getParameter("idCardNum");
		//银行卡cvv(后三码)
		String bankCardCvv = req.getParameter("bankCardCvv");
		//有效期
		String validTerm = req.getParameter("validTerm");
		//回调地址
		String bindCardCallbackUrl = req.getParameter("bindCardCallbackUrl");
		//通知地址
		String bindCardNotifyUrl = req.getParameter("bindCardNotifyUrl");
		String mode = req.getParameter("mode");
		String bankCode =  req.getParameter("bankCode");
		String cardType =  req.getParameter("cardType");

		BindCardBuilder builder = new BindCardBuilder(merchantId);
		builder.setMerchantUserId(merchantUserId)
				.setBankCardNumber(bankCardNumber)
				.setPhoneNumber(phoneNumber)
				.setName(name)
				.setIdCardNum(idCardNum)
				.setBankCardCvv(bankCardCvv)
				.setValidTerm(validTerm)
				.setBindCardCallbackUrl(bindCardCallbackUrl)
				.setBindCardNotifyUrl(bindCardNotifyUrl)
				.setMode(mode)
				.setBankCode(bankCode)
				.setCardType(cardType);

		final PrintWriter out = resp.getWriter();

		if(StringUtils.isBlank(merchantId)){
			out.println("参数异常</br>");
			out.println("商户编号不能为空");
			return;
		}else{
			if (merchantId.length() != 9){
				out.println("参数异常</br>");
				out.println("商户编号长度必须为9");
				return;
			}
		}

		BindCardExecuter executer = new BindCardExecuter();

		try {
			executer.bothBindCard(builder, new ResultListenerAdpater() {
				@Override
				public void success(JSONObject jsonObject) {

					out.println("请求成功！<br/>");
					String result = jsonObject.toJSONString();
					out.print(result);
				}
			});
		} catch (ResponseException e) {
			out.println("响应异常</br>");
			out.println(e.toString());
		} catch (HmacVerifyException e) {
			out.println("签名验证异常</br>");
			out.println(e.toString());
		} catch (RequestException e) {
			out.println("请求异常</br>");
			out.println(e.toString());
		} catch (UnknownException e) {
			out.println("未知异常</br>");
			out.println(e.toString());
		}
	}

	private boolean validateParams(HttpServletRequest req, PrintWriter out) {
		String merchantId = req.getParameter("merchantId");
		String merchantUserId = req.getParameter("merchantUserId");
		String bankCardNumber = req.getParameter("bankCardNumber");
		String phoneNumber = req.getParameter("phoneNumber");
		String name = req.getParameter("name");
		String idCardNum = req.getParameter("idCardNum");
		String bankCardCvv = req.getParameter("bankCardCvv");
		String validTerm = req.getParameter("validTerm");


		return false;
	}


}
