/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto;

import com.upay.sdk.crypto.exception.CryptoException;
import com.upay.sdk.crypto.sm.crypto.GlobalBouncyCastleProvider;
import com.upay.sdk.crypto.sm.crypto.RandomUtil;
import com.upay.sdk.crypto.utils.CryptoUtils;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class KeyUtil {
    public static final String CERT_TYPE_X509 = "X.509";
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final String SM2_DEFAULT_CURVE = "sm2p256v1";

    public static SecretKey generateKey(String algorithm) {
        return KeyUtil.generateKey(algorithm, -1);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        return KeyUtil.generateKey(algorithm, keySize, null);
    }

    public static SecretKey generateKey(String algorithm, int keySize, SecureRandom random) {
        algorithm = KeyUtil.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = KeyUtil.getKeyGenerator(algorithm);
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        SecretKey secretKey = algorithm.startsWith("PBE") ? KeyUtil.generatePBEKey(algorithm, null == key ? null : CryptoUtils.utf8Str((Object)key).toCharArray()) : (algorithm.startsWith("DES") ? KeyUtil.generateDESKey(algorithm, key) : (null == key ? KeyUtil.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        SecretKey secretKey;
        if (StringUtils.isBlank((CharSequence)algorithm) || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm [{}] is not a DES algorithm!");
        }
        if (null == key) {
            secretKey = KeyUtil.generateKey(algorithm);
        } else {
            KeySpec keySpec;
            try {
                keySpec = algorithm.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException((Throwable)e);
            }
            secretKey = KeyUtil.generateKey(algorithm, keySpec);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        if (StringUtils.isBlank((CharSequence)algorithm) || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm [{}] is not a PBE algorithm!");
        }
        if (null == key) {
            key = RandomUtil.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return KeyUtil.generateKey(algorithm, keySpec);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = KeyUtil.getSecretKeyFactory(algorithm);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return KeyUtil.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtil.getKeyFactory(algorithm).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return KeyUtil.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtil.getKeyFactory(algorithm).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        int keySize = 1024;
        if ("ECIES".equalsIgnoreCase(algorithm)) {
            keySize = 256;
        }
        return KeyUtil.generateKeyPair(algorithm, keySize);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return KeyUtil.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return KeyUtil.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return KeyUtil.generateKeyPair(algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        return KeyUtil.generateKeyPair(algorithm, null, params);
    }

    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        return KeyUtil.generateKeyPair(algorithm, 1024, seed, param);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return KeyUtil.generateKeyPair(algorithm, keySize, RandomUtil.createSecureRandom(seed), params);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = KeyUtil.getKeyPairGenerator(algorithm);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                keySize = 256;
            }
            if (null != random) {
                keyPairGen.initialize(keySize, random);
            } else {
                keyPairGen.initialize(keySize);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])params)) {
            for (AlgorithmParameterSpec param : params) {
                if (null == param) continue;
                try {
                    if (null != random) {
                        keyPairGen.initialize(param, random);
                        continue;
                    }
                    keyPairGen.initialize(param);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CryptoException((Throwable)e);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        KeyPairGenerator keyPairGen;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            keyPairGen = null == provider ? KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return keyPairGen;
    }

    public static KeyFactory getKeyFactory(String algorithm) {
        KeyFactory keyFactory;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            keyFactory = null == provider ? KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return keyFactory;
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        SecretKeyFactory keyFactory;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            keyFactory = null == provider ? SecretKeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : SecretKeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return keyFactory;
    }

    public static KeyGenerator getKeyGenerator(String algorithm) {
        KeyGenerator generator;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            generator = null == provider ? KeyGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return generator;
    }

    public static String getMainAlgorithm(String algorithm) {
        int slashIndex = algorithm.indexOf(47);
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        if (CryptoUtils.startWithIgnoreCase((CharSequence)algorithm, (CharSequence)"ECIESWith")) {
            return "EC";
        }
        int indexOfWith = CryptoUtils.lastIndexOfIgnoreCase((CharSequence)algorithm, (CharSequence)"with");
        if (indexOfWith > 0) {
            algorithm = CryptoUtils.subSuf((CharSequence)algorithm, (int)(indexOfWith + "with".length()));
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm) || "ECIES".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        return keyStore;
    }

    public static KeyPair getKeyPair(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = KeyUtil.readKeyStore(type, in, password);
        return KeyUtil.getKeyPair(keyStore, password, alias);
    }

    public static KeyPair getKeyPair(KeyStore keyStore, char[] password, String alias) {
        PrivateKey privateKey;
        PublicKey publicKey;
        try {
            publicKey = keyStore.getCertificate(alias).getPublicKey();
            privateKey = (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        return new KeyPair(publicKey, privateKey);
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        return KeyUtil.readCertificate(CERT_TYPE_X509, in, password, alias);
    }

    public static PublicKey readPublicKeyFromCert(InputStream in) {
        Certificate certificate = KeyUtil.readX509Certificate(in);
        if (null != certificate) {
            return certificate.getPublicKey();
        }
        return null;
    }

    public static Certificate readX509Certificate(InputStream in) {
        return KeyUtil.readCertificate(CERT_TYPE_X509, in);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = KeyUtil.readKeyStore(type, in, password);
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static Certificate readCertificate(String type, InputStream in) {
        try {
            return KeyUtil.getCertificateFactory(type).generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static CertificateFactory getCertificateFactory(String type) {
        CertificateFactory factory;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            factory = null == provider ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, provider);
        }
        catch (CertificateException e) {
            throw new CryptoException((Throwable)e);
        }
        return factory;
    }
}

