/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.wechatcomplaint.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class WechatComplaintNegotiationHistoryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String merchantOrderNumber;
    private String wechatOrderNumber;
    private String partnerId;

    public WechatComplaintNegotiationHistoryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public WechatComplaintNegotiationHistoryBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public WechatComplaintNegotiationHistoryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getMerchantOrderNumber() {
        return this.merchantOrderNumber;
    }

    public WechatComplaintNegotiationHistoryBuilder setMerchantOrderNumber(String merchantOrderNumber) {
        this.merchantOrderNumber = merchantOrderNumber;
        return this;
    }

    public String getWechatOrderNumber() {
        return this.wechatOrderNumber;
    }

    public WechatComplaintNegotiationHistoryBuilder setWechatOrderNumber(String wechatOrderNumber) {
        this.wechatOrderNumber = wechatOrderNumber;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

