/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.webox.builder.WalletSafeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletSafeExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(WalletSafeExecuter.class);

    public void createToken(WalletSafeBuilder builder, ResultListener resultListener) {
        block7: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("walletSafe create token requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxWalletSafeCreateToken(), requestData);
                LOGGER.info("walletSafe create toke responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("walletSafe create toke responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block7;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block7;
                }
                if (Constants.REDIRECT.equals(status)) {
                    resultListener.redirect(responseData, responseData.getString("payUrl"));
                    break block7;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("walletSafe create toke error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

