/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.webox.builder.ValueAddedCreateBuilder;
import com.upay.sdk.webox.builder.ValueAddedQueryWalletBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueAddedExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ValueAddedExecuter.class);

    public void bothCreate(ValueAddedCreateBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("ValueAdded bothCreate requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxValueAddedCreateUrl(), requestData);
                LOGGER.info("ValueAdded bothCreate responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("ValueAdded bothCreate responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("ValueAdded bothCreate error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothQueryWallet(ValueAddedQueryWalletBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("ValueAdded bothQueryWallet requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxValueAddedQueryUserInfoUrl(), requestData);
                LOGGER.info("ValueAdded bothQueryWallet responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("ValueAdded bothQueryWallet responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("ValueAdded bothCreate error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

