/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class RedPacketBillQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String walletId;
    private String pageIndex;
    private String pageSize;
    private String queryMonth;
    private String tradeType;
    private String direction;

    public RedPacketBillQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RedPacketBillQueryBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public RedPacketBillQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RedPacketBillQueryBuilder setPageIndex(String pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    public RedPacketBillQueryBuilder setQueryMonth(String queryMonth) {
        this.queryMonth = queryMonth;
        return this;
    }

    public RedPacketBillQueryBuilder setTradeType(String tradeType) {
        this.tradeType = tradeType;
        return this;
    }

    public RedPacketBillQueryBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public RedPacketBillQueryBuilder setPageSize(String pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public RedPacketBillQueryBuilder setDirection(String direction) {
        this.direction = direction;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

