/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transferDomestic.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.transferDomestic.builder.AccountBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDomesticAccountExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(TransferDomesticAccountExecuter.class);
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, "availableTransferBalance", "dateTime", Constants.STATUS};

    public void availableTransferBalance(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "],availableTransferBalance:[" + ConfigurationUtils.getTransferDomesticAccountAvailableBalanceUrl() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getTransferDomesticAccountAvailableBalanceUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void availableTransferBalance(AccountBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.encryptBuild();
        LOGGER.debug("V_2 requestData:[" + requestData.toJSONString() + "],transferDomesticOrderUrl:[" + ConfigurationUtils.getTransferDomesticAccountAvailableBalanceUrl() + "]");
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getTransferDomesticAccountAvailableBalanceUrl(), requestData);
        LOGGER.debug("V_2 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.verifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothAvailableTransferBalance(AccountBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("V_3 requestData:[" + requestData.toJSONString() + "],transferDomesticOrderUrl:[" + ConfigurationUtils.getTransferDomesticAccountAvailableBalanceUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferDomesticAccountAvailableBalanceUrl(), requestData);
        LOGGER.debug("V_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

