/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.tls.support.bc.lowVersion;

import com.upay.sdk.tls.support.bc.lowVersion.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class TLSSocketConnectionFactory
extends SSLSocketFactory {
    @Override
    public String[] getDefaultCipherSuites() {
        return new String[]{"TLSv1.2"};
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return new String[]{"TLSv1.2"};
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean arg3) throws IOException {
        if (socket == null) {
            socket = new Socket();
        }
        if (!socket.isConnected()) {
            socket.connect(new InetSocketAddress(host, port));
        }
        return new SSLSocketImpl(socket, host);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(host, port));
        return new SSLSocketImpl(socket, host);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(host, port));
        return new SSLSocketImpl(socket, host.getHostName());
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = new Socket();
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(new InetSocketAddress(host, port));
        return new SSLSocketImpl(socket, host);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = new Socket();
        socket.bind(new InetSocketAddress(localAddress, localPort));
        socket.connect(new InetSocketAddress(address, port));
        return new SSLSocketImpl(socket, address.getHostName());
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

