/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.tls.support.bc;

import com.upay.sdk.tls.support.bc.SimpleTrustManager;
import com.upay.sdk.tls.support.bc.lowVersion.TLSSocketConnectionFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.SSLSocketFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsSocketConnectionFactory
extends SSLSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsSocketConnectionFactory.class);
    private static final SSLSocketFactory proxySSLSocketFactory;

    @Override
    public String[] getDefaultCipherSuites() {
        return proxySSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return proxySSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean arg3) throws IOException {
        return proxySSLSocketFactory.createSocket(socket, host, port, arg3);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return proxySSLSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return proxySSLSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return proxySSLSocketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return proxySSLSocketFactory.createSocket(address, port, localAddress, localPort);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        double bcVersion = Security.getProvider("BC").getVersion();
        LOGGER.info("BouncyCastle version:{}", (Object)bcVersion);
        if (bcVersion < 1.63) {
            proxySSLSocketFactory = new TLSSocketConnectionFactory();
        } else {
            try {
                Field x509TrustManagerField;
                Object contextData;
                proxySSLSocketFactory = new SSLSocketFactoryImpl();
                if (bcVersion > 1.64) {
                    Field contextDataField = proxySSLSocketFactory.getClass().getSuperclass().getDeclaredField("contextData");
                    contextDataField.setAccessible(true);
                    contextData = contextDataField.get(proxySSLSocketFactory);
                    x509TrustManagerField = contextData.getClass().getDeclaredField("x509TrustManager");
                } else {
                    Field contextDataField = proxySSLSocketFactory.getClass().getSuperclass().getDeclaredField("context");
                    contextDataField.setAccessible(true);
                    contextData = contextDataField.get(proxySSLSocketFactory);
                    x509TrustManagerField = contextData.getClass().getSuperclass().getDeclaredField("x509TrustManager");
                }
                x509TrustManagerField.setAccessible(true);
                x509TrustManagerField.set(contextData, (Object)new SimpleTrustManager());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

