/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.sjtTransfer.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.sjtTransfer.builder.OrderBuilder;
import com.upay.sdk.sjtTransfer.builder.OrderConfirmBuilder;
import com.upay.sdk.sjtTransfer.builder.OrderQueryBuilder;
import com.upay.sdk.sjtTransfer.builder.OrderSendSmsBuilder;
import com.upay.sdk.sjtTransfer.builder.OrderVoucherBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SJTTransferOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(SJTTransferOrderExecuter.class);

    public void bothOrder(OrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("SJTTransferOrderExecuter bothOrder requestData:[" + requestData.toJSONString() + "],orderUrl:[" + ConfigurationUtils.getSJTTransferOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getSJTTransferOrderUrl(), requestData);
        LOGGER.debug("SJTTransferOrderExecuter bothOrder responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:{}", (Object)responseData);
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothOrderConfirm(OrderConfirmBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("SJTTransferOrderExecuter bothOrderConfirm requestData:[" + requestData.toJSONString() + "],orderConfirmUrl:[" + ConfigurationUtils.getSJTTransferOrderConfirmUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getSJTTransferOrderConfirmUrl(), requestData);
        LOGGER.debug("SJTTransferOrderExecuter bothOrderConfirm responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothOrderSendSms(OrderSendSmsBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("SJTTransferOrderExecuter bothOrderSendSms requestData:[" + requestData.toJSONString() + "],orderSendSmsUrl:[" + ConfigurationUtils.getSJTTransferOrderSendSmsUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getSJTTransferOrderSendSmsUrl(), requestData);
        LOGGER.debug("SJTTransferOrderExecuter bothOrderSendSms responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothOrderQuery(OrderQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("SJTTransferOrderExecuter bothOrderQuery requestData:[" + requestData.toJSONString() + "],orderQueryUrl:[" + ConfigurationUtils.getSJTTransferOrderQueryUrl() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getSJTTransferOrderQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            LOGGER.debug("SJTTransferOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothGenerateVoucher(OrderVoucherBuilder builder, ResultListener listener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("bothGenerateVoucher requestData:[" + requestData + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getSJTTransferOrderVoucherUrl(), requestData);
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        listener.success(responseData);
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        LOGGER.info("SJTTransferOrderExecuter bothCipherCallback responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("SJTTransferOrderExecuter bothCipherCallback data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        LOGGER.info("SJTTransferOrderExecuter bothCipherCallback status:[" + status + "]");
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("PROCESSING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

