/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.StringUtils;

public class BindCardQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String agreementNo;

    public String getMerchantId() {
        return this.merchantId;
    }

    public BindCardQueryBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getAgreementNo() {
        return this.agreementNo;
    }

    public BindCardQueryBuilder setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
        return this;
    }

    public BindCardQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.agreementNo)) {
            json.put("agreementNo", (Object)this.agreementNo);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.agreementNo));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

