/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.StringUtils;

public class BindCardConfirmBuilder
extends BuilderSupport {
    private String merchantId;
    private String bindCardRecordId;
    private String kaptchaCode;

    public String getKaptchaCode() {
        return this.kaptchaCode;
    }

    public BindCardConfirmBuilder setKaptchaCode(String kaptchaCode) {
        this.kaptchaCode = kaptchaCode;
        return this;
    }

    public String getBindCardRecordId() {
        return this.bindCardRecordId;
    }

    public BindCardConfirmBuilder setBindCardRecordId(String bindCardRecordId) {
        this.bindCardRecordId = bindCardRecordId;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public BindCardConfirmBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public BindCardConfirmBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.bindCardRecordId)) {
            json.put("bindCardRecordId", (Object)this.bindCardRecordId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.kaptchaCode)) {
            json.put("kaptchaCode", (Object)this.kaptchaCode);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.bindCardRecordId)).append(StringUtils.defaultString((String)this.kaptchaCode));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

