/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.onlinepay.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.RefundCollectDetail;
import com.upay.sdk.entity.SubsidyRefundOrder;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class RefundBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String orderId;
    private String remark;
    private String notifyUrl;
    private String isCollect;
    private String partnerId;
    private String refundSubsidy;
    private String subsidyMoney;
    private List<SubsidyRefundOrder> refundSubsidyDetail = new LinkedList<SubsidyRefundOrder>();
    private List<RefundCollectDetail> refundCollectDetail = new LinkedList<RefundCollectDetail>();

    public List<SubsidyRefundOrder> getRefundSubsidyDetail() {
        return this.refundSubsidyDetail;
    }

    public void setRefundSubsidyDetail(List<SubsidyRefundOrder> refundSubsidyDetail) {
        this.refundSubsidyDetail = refundSubsidyDetail;
    }

    public void addRefundSubsidyDetail(SubsidyRefundOrder subsidyRefundOrder) {
        this.refundSubsidyDetail.add(subsidyRefundOrder);
    }

    public String getRefundSubsidy() {
        return this.refundSubsidy;
    }

    public RefundBuilder setRefundSubsidy(String refundSubsidy) {
        this.refundSubsidy = refundSubsidy;
        return this;
    }

    public String getSubsidyMoney() {
        return this.subsidyMoney;
    }

    public RefundBuilder setSubsidyMoney(String subsidyMoney) {
        this.subsidyMoney = subsidyMoney;
        return this;
    }

    public RefundBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RefundBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RefundBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public RefundBuilder setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public RefundBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getIsCollect() {
        return this.isCollect;
    }

    public RefundBuilder setIsCollect(String isCollect) {
        this.isCollect = isCollect;
        return this;
    }

    public List<RefundCollectDetail> getRefundCollectDetail() {
        return this.refundCollectDetail;
    }

    public void setRefundCollectDetail(List<RefundCollectDetail> refundCollectDetail) {
        this.refundCollectDetail = refundCollectDetail;
    }

    public void addRefundCollectDetail(RefundCollectDetail refundCollectDetail) {
        this.refundCollectDetail.add(refundCollectDetail);
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderId)) {
            json.put("orderId", (Object)this.orderId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            json.put("partnerId", (Object)this.partnerId);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append((String)ObjectUtils.defaultIfNull((Object)this.amount, (Object)"")).append(StringUtils.defaultString((String)this.orderId)).append(StringUtils.defaultString((String)this.notifyUrl)).append(StringUtils.defaultString((String)this.remark)).append(StringUtils.defaultString((String)this.partnerId));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

