/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.member.v_2.executer;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.exception.RequestParamException;
import com.upay.sdk.exception.ResponseDecryptException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.member.v_2.builder.SnapshotQueryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemberSnapshotExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberSnapshotExecuter.class);

    public void queryMemberSnapshot(SnapshotQueryBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getMemberSnapshotQueryUrl();
        try {
            HttpReponse httpJsonResponse = HttpClientUtils.sdkPost(url, builder);
            Object resObject = httpJsonResponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)resObject;
            if (httpJsonResponse.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("querySettlementRecord request response error,errorCode:{}", (Object)httpJsonResponse.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("queryMemberSnapshot request url:[{}] param error:{}", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("queryMemberSnapshot request url:[{}] response decrypt error:{}", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("queryMemberSnapshot request url:[{}] UnknownException error:{}", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }
}

