/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.hg.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.BankCard;
import org.apache.commons.lang3.StringUtils;

public final class RechargeBuilder
extends BuilderSupport {
    private String merchantId;
    private String rechargeMemberId;
    private String requestId;
    private String orderAmount;
    private String orderCurrency;
    private String notifyUrl;
    private String callbackUrl;
    private BankCard bankCard;

    public RechargeBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RechargeBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public RechargeBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RechargeBuilder setRechargeMemberId(String rechargeMemberId) {
        this.rechargeMemberId = rechargeMemberId;
        return this;
    }

    public RechargeBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public RechargeBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public RechargeBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public RechargeBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public BankCard getBankCard() {
        return this.bankCard;
    }

    public void setBankCard(BankCard bankCard) {
        this.bankCard = bankCard;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.rechargeMemberId)) {
            json.put("rechargeMemberId", (Object)this.rechargeMemberId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderAmount)) {
            json.put("orderAmount", (Object)this.orderAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderCurrency)) {
            json.put("orderCurrency", (Object)this.orderCurrency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (this.bankCard != null) {
            json.put("name", (Object)this.bankCard.getName());
            json.put("cardNo", (Object)this.bankCard.getCardNo());
            json.put("cvv2", (Object)this.bankCard.getCvv2());
            json.put("expiryDate", (Object)this.bankCard.getExpiryDate());
            json.put("idNo", (Object)this.bankCard.getIdNo());
            json.put("mobileNo", (Object)this.bankCard.getMobileNo());
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.rechargeMemberId, (String)"")).append(StringUtils.defaultString((String)this.orderAmount, (String)"")).append(StringUtils.defaultString((String)this.orderCurrency, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.callbackUrl, (String)""));
        if (this.bankCard != null) {
            hmacSource.append(StringUtils.defaultString((String)this.bankCard.getName())).append(StringUtils.defaultString((String)this.bankCard.getCardNo())).append(StringUtils.defaultString((String)this.bankCard.getCvv2())).append(StringUtils.defaultString((String)this.bankCard.getIdNo())).append(StringUtils.defaultString((String)this.bankCard.getExpiryDate())).append(StringUtils.defaultString((String)this.bankCard.getMobileNo()));
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

