/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignpayExchangesettlement.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.foreignpayExchangesettlement.builder.ForeignpayExchangesettlementOrderV3Builder;
import com.upay.sdk.foreignpayExchangesettlement.builder.ForeignpayExchangesettlementQueryV3Builder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignpayExchangesettlementOrderV3Executer
extends Executer {
    private static final Logger log = LoggerFactory.getLogger(ForeignpayExchangesettlementOrderV3Executer.class);

    public void createOrder(ForeignpayExchangesettlementOrderV3Builder builder, ResultListener resultListener) {
        log.info("ForeignpayExchangesettlementOrderV3Executer createOrder builder: {}", (Object)JSON.toJSONString((Object)builder));
        JSONObject jsonObject = builder.bothEncryptBuild();
        log.info("ForeignpayExchangesettlementOrderV3Executer createOrder requestData: {}", (Object)jsonObject);
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignpayV3OrderUrl(), jsonObject);
        log.info("ForeignpayExchangesettlementOrderV3Executer createOrder responseStr: {}, requestData: {}", (Object)responseStr, (Object)jsonObject);
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        log.info("ForeignpayExchangesettlementOrderV3Executer createOrder responseData: {}, requestData: {}", (Object)responseData, (Object)jsonObject);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            this.bothVerifyHmacOrder(responseData);
            resultListener.success(responseData);
        } else {
            resultListener.failure(responseData);
        }
    }

    public void query(ForeignpayExchangesettlementQueryV3Builder builder, ResultListener resultListener) {
        log.info("ForeignpayExchangesettlementOrderV3Executer query builder: {}", (Object)JSON.toJSONString((Object)builder));
        JSONObject jsonObject = builder.bothEncryptBuild();
        log.info("ForeignpayExchangesettlementOrderV3Executer query requestData: {}", (Object)jsonObject);
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignpayV3QueryUrl(), jsonObject);
        log.info("ForeignpayExchangesettlementOrderV3Executer query responseStr: {}, requestData: {}", (Object)responseStr, (Object)jsonObject);
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        log.info("ForeignpayExchangesettlementOrderV3Executer query responseData: {}, requestData: {}", (Object)responseData, (Object)jsonObject);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            this.bothVerifyHmacOrder(responseData);
            resultListener.success(responseData);
        } else {
            resultListener.failure(responseData);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status)) {
                listener.failure(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

