/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.ProductDetail;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ReceiptOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String orderAmount;
    private String orderCurrency;
    private String requestId;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private String clientIp;
    private String agreementNo;
    private String walletId;
    private String userId;
    private String userFeeAmount;
    private String channelFlag;
    private String isNeedSms;
    private String cvv;
    private String expiredYear;
    private String expiredMonth;
    private String partnerId;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();
    private String province;
    private String city;
    private String paymentMerchantId;
    private String bindCardId;
    private String distributorNo;
    private String reportSerialNo;
    private String appId;
    private String openId;

    public String getDistributorNo() {
        return this.distributorNo;
    }

    public ReceiptOrderBuilder setDistributorNo(String distributorNo) {
        this.distributorNo = distributorNo;
        return this;
    }

    public String getReportSerialNo() {
        return this.reportSerialNo;
    }

    public ReceiptOrderBuilder setReportSerialNo(String reportSerialNo) {
        this.reportSerialNo = reportSerialNo;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public ReceiptOrderBuilder setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getOpenId() {
        return this.openId;
    }

    public ReceiptOrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public String getBindCardId() {
        return this.bindCardId;
    }

    public ReceiptOrderBuilder setBindCardId(String bindCardId) {
        this.bindCardId = bindCardId;
        return this;
    }

    public ReceiptOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public ReceiptOrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public ReceiptOrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public ReceiptOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ReceiptOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public ReceiptOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public ReceiptOrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public ReceiptOrderBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public ReceiptOrderBuilder setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
        return this;
    }

    public ReceiptOrderBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public ReceiptOrderBuilder setUserFeeAmount(String userFeeAmount) {
        this.userFeeAmount = userFeeAmount;
        return this;
    }

    public ReceiptOrderBuilder setChannelFlag(String channelFlag) {
        this.channelFlag = channelFlag;
        return this;
    }

    public ReceiptOrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public ReceiptOrderBuilder setNeedSms(String needSms) {
        this.isNeedSms = needSms;
        return this;
    }

    public ReceiptOrderBuilder setCvv(String cvv) {
        this.cvv = cvv;
        return this;
    }

    public ReceiptOrderBuilder setExpiredYear(String expiredYear) {
        this.expiredYear = expiredYear;
        return this;
    }

    public ReceiptOrderBuilder setExpiredMonth(String expiredMonth) {
        this.expiredMonth = expiredMonth;
        return this;
    }

    public ReceiptOrderBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public ReceiptOrderBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public String getProvince() {
        return this.province;
    }

    public ReceiptOrderBuilder setProvince(String province) {
        this.province = province;
        return this;
    }

    public String getCity() {
        return this.city;
    }

    public ReceiptOrderBuilder setCity(String city) {
        this.city = city;
        return this;
    }

    public String getPaymentMerchantId() {
        return this.paymentMerchantId;
    }

    public ReceiptOrderBuilder setPaymentMerchantId(String paymentMerchantId) {
        this.paymentMerchantId = paymentMerchantId;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

