/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.shop.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.builder.BuilderSupportWrap;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.enjoy.shop.builder.ShopRateQueryBuilder;
import com.upay.sdk.enjoy.shop.builder.ShopRateUpdateBuilder;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShopRateExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ShopRateExecuter.class);

    public void update(ShopRateUpdateBuilder builder, ResultListener resultListener) {
        this.baseSendHttp(ConfigurationUtils.getEnjoyShopRateUpdateUrl(), builder, resultListener);
    }

    public void query(ShopRateQueryBuilder builder, ResultListener resultListener) {
        this.baseSendHttp(ConfigurationUtils.getEnjoyShopRateQueryUrl(), builder, resultListener);
    }

    private void baseSendHttp(String url, BuilderSupportWrap builder, ResultListener resultListener) {
        try {
            LOGGER.debug("baseSendHttp requestData:[" + JSON.toJSONString((Object)builder) + "]");
            HttpReponse httpReponse = HttpClientUtils.sdkPost(url, builder);
            LOGGER.info("baseSendHttp responseStr:[" + httpReponse.getDecryptResponse() + "]");
            Object resObject = httpReponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)resObject;
            if (httpReponse.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("getLoginTicket request response error,errorCode:{}", (Object)httpReponse.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (Exception e) {
            LOGGER.error("bothAuth error", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

