/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.shop.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.enjoy.shop.builder.PostReviewComplementBuilder;
import com.upay.sdk.enjoy.shop.builder.ShopDeclareBuilder;
import com.upay.sdk.enjoy.shop.builder.ShopDeclareQueryBuilder;
import com.upay.sdk.enjoy.shop.builder.ShopElectronicSignBuilder;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShopDeclareExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ShopDeclareExecuter.class);

    public void bothCreate(ShopDeclareBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.debug("bothCreate requestData:[" + JSON.toJSONString((Object)builder) + "]");
            HttpReponse httpReponse = HttpClientUtils.sdkPost(ConfigurationUtils.getEnjoyShopDeclareUrl(), builder);
            LOGGER.info("bothCreate responseStr:[" + httpReponse.getDecryptResponse() + "]");
            Object resObject = httpReponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)resObject;
            if (httpReponse.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("getLoginTicket request response error,errorCode:{}", (Object)httpReponse.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (Exception e) {
            LOGGER.error("bothAuth error", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void queryDeclare(ShopDeclareQueryBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.debug("queryDeclare requestData:[" + JSON.toJSONString((Object)builder) + "]");
            HttpReponse httpReponse = HttpClientUtils.sdkPost(ConfigurationUtils.getEnjoyShopDeclareQueryUrl(), builder);
            LOGGER.info("queryDeclare responseStr:[" + httpReponse.getDecryptResponse() + "]");
            Object resObject = httpReponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)resObject;
            if (httpReponse.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("getLoginTicket request response error,errorCode:{}", (Object)httpReponse.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (Exception e) {
            LOGGER.error("queryDeclare error", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void postReviewComplement(PostReviewComplementBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.debug("postReviewComplement requestData:[" + JSON.toJSONString((Object)builder) + "]");
            HttpReponse httpReponse = HttpClientUtils.sdkPost(ConfigurationUtils.getEnjoyPostReviewComplementUrl(), builder);
            LOGGER.info("postReviewComplement responseStr:[" + httpReponse.getDecryptResponse() + "]");
            Object resObject = httpReponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)resObject;
            if (httpReponse.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("getLoginTicket request response error,errorCode:{}", (Object)httpReponse.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (Exception e) {
            LOGGER.error("postReviewComplement error", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void electronicSign(ShopElectronicSignBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.debug("electronicSign requestData:[" + JSON.toJSONString((Object)builder) + "]");
            HttpReponse httpReponse = HttpClientUtils.sdkPost(ConfigurationUtils.getEnjoyShopElectronicSignUrl(), builder);
            LOGGER.info("electronicSign responseStr:[" + httpReponse.getDecryptResponse() + "]");
            Object resObject = httpReponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)resObject;
            if (httpReponse.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("electronicSign request response error,errorCode:{}", (Object)httpReponse.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (Exception e) {
            LOGGER.error("electronicSign error", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

