/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.certificate.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.enjoy.certificate.builder.CertificateExpireUpdateShopBusinessBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExpireUpdateShopBusinessExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(CertificateExpireUpdateShopBusinessExecuter.class);

    public void updateShopBusiness(CertificateExpireUpdateShopBusinessBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("updateShopBusiness requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEnjoyCertificateExpireUpdateShopBusinessUrl(), requestData);
                LOGGER.info("updateShopBusiness responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("updateShopBusiness bothDecryptWrap responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothAuth error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

