/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eaccount.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.eaccount.builder.ElectronicAccountWithdrawOrderBuilder;
import com.upay.sdk.eaccount.builder.ElectronicAccountWithdrawOrderQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicAccountWithdrawOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ElectronicAccountWithdrawOrderExecuter.class);

    public void bothOrder(ElectronicAccountWithdrawOrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("ElectronicAccountWithdrawOrderExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],getElectronicAccountWithdrawOrderUrl:[" + ConfigurationUtils.getElectronicAccountTransInOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getElectronicAccountTransInOrderUrl(), requestData);
        LOGGER.debug("ElectronicAccountWithdrawOrderExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        String status = responseData.getString(Constants.STATUS);
        this.bothVerifyHmacOrder(responseData);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothQuery(ElectronicAccountWithdrawOrderQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("ElectronicAccountWithdrawOrderExecuter queryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getElectronicAccountTransInOrderQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.debug("ElectronicAccountWithdrawOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            String status = responseData.getString(Constants.STATUS);
            this.bothVerifyHmacOrder(responseData);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        LOGGER.info("ElectronicAccountWithdrawOrderExecuter bothCipherCallback responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("ElectronicAccountWithdrawOrderExecuter bothCipherCallback data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        LOGGER.info("ElectronicAccountWithdrawOrderExecuter bothCipherCallback status:[" + status + "]");
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status)) {
                listener.failure(data);
            } else if ("CREDITING".equals(status)) {
                listener.pending(data);
            } else if ("PROCESSING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

