/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eaccount.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.eaccount.builder.ElectronicAccountBalanceBuilder;
import com.upay.sdk.eaccount.builder.ElectronicAccountQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicAccountExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ElectronicAccountExecuter.class);

    public void bothQuery(ElectronicAccountQueryBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("ElectronicAccountQueryExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],getElectronicAccountQueryUrl:[" + ConfigurationUtils.getElectronicAccountQueryUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getElectronicAccountQueryUrl(), requestData);
        LOGGER.debug("ElectronicAccountQueryExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        String status = responseData.getString(Constants.STATUS);
        this.bothVerifyHmacOrder(responseData);
        if (Constants.SUCCESS.equals(status)) {
            resultListener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bothBalance(ElectronicAccountBalanceBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("ElectronicAccountBalanceExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],getElectronicAccountBalanceUrl:[" + ConfigurationUtils.getElectronicAccountBalanceUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getElectronicAccountBalanceUrl(), requestData);
        LOGGER.debug("ElectronicAccountBalanceExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        String status = responseData.getString(Constants.STATUS);
        this.bothVerifyHmacOrder(responseData);
        if (Constants.SUCCESS.equals(status)) {
            resultListener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        LOGGER.info("ElectronicAccountQueryExecuter bothCipherCallback responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("ElectronicAccountQueryExecuter bothCipherCallback data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        listener.success(data);
    }
}

