/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.currencyexchange.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import java.math.BigDecimal;

public class ExchangeOrderBuilder
extends BuilderSupport {
    private String orderNo;
    private String merchantId;
    private String buyCurrency;
    private String sellCurrency;
    private String side;
    private BigDecimal tradeAmount;
    private String settleDay;
    private String exchangeMode;
    private String callbackUrl;

    public ExchangeOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public ExchangeOrderBuilder setOrderNo(String orderNo) {
        this.orderNo = orderNo;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public ExchangeOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getBuyCurrency() {
        return this.buyCurrency;
    }

    public ExchangeOrderBuilder setBuyCurrency(String buyCurrency) {
        this.buyCurrency = buyCurrency;
        return this;
    }

    public String getSellCurrency() {
        return this.sellCurrency;
    }

    public ExchangeOrderBuilder setSellCurrency(String sellCurrency) {
        this.sellCurrency = sellCurrency;
        return this;
    }

    public String getSide() {
        return this.side;
    }

    public ExchangeOrderBuilder setSide(String side) {
        this.side = side;
        return this;
    }

    public BigDecimal getTradeAmount() {
        return this.tradeAmount;
    }

    public ExchangeOrderBuilder setTradeAmount(BigDecimal tradeAmount) {
        this.tradeAmount = tradeAmount;
        return this;
    }

    public String getSettleDay() {
        return this.settleDay;
    }

    public ExchangeOrderBuilder setSettleDay(String settleDay) {
        this.settleDay = settleDay;
        return this;
    }

    public String getExchangeMode() {
        return this.exchangeMode;
    }

    public ExchangeOrderBuilder setExchangeMode(String exchangeMode) {
        this.exchangeMode = exchangeMode;
        return this;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public ExchangeOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }
}

