/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.core;

import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.core.Environment;
import com.upay.sdk.crypto.CertificateReader;
import com.upay.sdk.crypto.EncryptionAlgorithm;
import com.upay.sdk.crypto.SdkEncryptDecryptSupport;
import com.upay.sdk.crypto.exception.EncryptDecryptNotSupportException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CipherAdapter.class);
    private final String merchantId;
    private SdkEncryptDecryptSupport sdkEncryptDecryptSupport;
    private CertificateReader certificateReader;
    private EncryptionAlgorithm encryptionAlgorithm;

    public CipherAdapter(String merchantId) throws EncryptDecryptNotSupportException {
        this.merchantId = merchantId;
        this.init();
    }

    private void init() throws EncryptDecryptNotSupportException {
        List<CertificateReader> certificateReaders = Environment.getCertificateReaderList();
        String cryptoConfig = ConfigurationUtils.getClientCryptoType(this.merchantId);
        if (cryptoConfig != null && !cryptoConfig.trim().isEmpty()) {
            cryptoConfig = cryptoConfig.trim();
            try {
                this.encryptionAlgorithm = EncryptionAlgorithm.valueOf(cryptoConfig.toUpperCase());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("client.crypto value[" + cryptoConfig + "] error,value allow EncryptionAlgorithm enum names!");
            }
            boolean foundImpl = false;
            for (CertificateReader reader : certificateReaders) {
                if (!reader.getEncryptionAlgorithm().equals((Object)this.encryptionAlgorithm)) continue;
                foundImpl = true;
                this.encryptionAlgorithm = reader.getEncryptionAlgorithm();
                this.certificateReader = reader;
                break;
            }
            if (!foundImpl) {
                throw new IllegalStateException("not found crypto impl! encryptionAlgorithm is " + this.encryptionAlgorithm.name());
            }
        }
        if (this.encryptionAlgorithm == null) {
            for (CertificateReader reader : certificateReaders) {
                if (!reader.canParsePrivateKey(this.merchantId)) continue;
                this.encryptionAlgorithm = reader.getEncryptionAlgorithm();
                this.certificateReader = reader;
                break;
            }
        }
        if (this.encryptionAlgorithm == null) {
            throw new IllegalStateException("not found crypto impl! Please check the certificate and sdk crypto jars");
        }
        this.sdkEncryptDecryptSupport = Environment.getSdkEncryptDecryptSupport(this.encryptionAlgorithm);
        LOGGER.info("merchantId:[{}] use encryptionAlgorithm:[{}],impl:{}", new Object[]{this.merchantId, this.encryptionAlgorithm.name(), this.sdkEncryptDecryptSupport.getClass().getName()});
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public SdkEncryptDecryptSupport getSdkEncryptDecryptSupport() {
        return this.sdkEncryptDecryptSupport;
    }

    public String getPublicKey() throws Exception {
        return this.certificateReader.readPublicKey(this.merchantId);
    }

    public String getPrivateKey() throws Exception {
        return this.certificateReader.readPrivateKey(this.merchantId);
    }
}

