/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cashier.eaccount.executer;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.cashier.eaccount.builder.ExclusiveAccountOrderCancelBuilder;
import com.upay.sdk.cashier.eaccount.builder.ExclusiveAccountProBatchOpenBuilder;
import com.upay.sdk.cashier.eaccount.builder.ExclusiveAccountProQueryBuilder;
import com.upay.sdk.cashier.eaccount.builder.ExclusiveAccountProUpdateBuilder;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveAccountProExecuter {
    static final Logger LOGGER = LoggerFactory.getLogger(ExclusiveAccountProExecuter.class);

    public void exclusiveAccountBatchOpen(ExclusiveAccountProBatchOpenBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.info("exclusiveAccountBatchOpen requestData:{}", (Object)JSONObject.toJSONString((Object)builder));
            HttpReponse httpJsonResponse = HttpClientUtils.sdkPost(ConfigurationUtils.getExclusiveAccountBatchOpen(), builder);
            Object resObject = httpJsonResponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseData = (JSONObject)resObject;
            LOGGER.info("exclusiveAccountBatchOpen responseStr :{}", (Object)responseData);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("exclusiveAccountBatchOpen order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void exclusiveAccountQuery(ExclusiveAccountProQueryBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.info("exclusiveAccountQuery requestData:{}", (Object)JSONObject.toJSONString((Object)builder));
            HttpReponse httpJsonResponse = HttpClientUtils.sdkPost(ConfigurationUtils.getExclusiveAccountQuery(), builder);
            Object resObject = httpJsonResponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseData = (JSONObject)resObject;
            LOGGER.info("exclusiveAccountQuery responseStr :{}", (Object)responseData);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("exclusiveAccountQuery order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void exclusiveAccountUpdate(ExclusiveAccountProUpdateBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.info("exclusiveAccountUpdate requestData:{}", (Object)JSONObject.toJSONString((Object)builder));
            HttpReponse httpJsonResponse = HttpClientUtils.sdkPost(ConfigurationUtils.getExclusiveAccountUpdate(), builder);
            Object resObject = httpJsonResponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseData = (JSONObject)resObject;
            LOGGER.info("exclusiveAccountUpdate responseStr :{}", (Object)responseData);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("exclusiveAccountUpdate order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void exclusiveAccountOrderCancel(ExclusiveAccountOrderCancelBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.info("exclusiveAccountOrderCancel requestData:{}", (Object)JSONObject.toJSONString((Object)builder));
            HttpReponse httpJsonResponse = HttpClientUtils.sdkPost(ConfigurationUtils.getExclusiveAccountOrderCancel(), builder);
            Object resObject = httpJsonResponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseData = (JSONObject)resObject;
            LOGGER.info("exclusiveAccountOrderCancel responseStr :{}", (Object)responseData);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("exclusiveAccountOrderCancel order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

