﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Security.Cryptography;
using Org.BouncyCastle.Crypto.Parameters;
using Org.BouncyCastle.Security;
using Org.BouncyCastle.Crypto;
using Org.BouncyCastle.Crypto.Encodings;
using Org.BouncyCastle.Crypto.Engines;
using Org.BouncyCastle.Math;
using WNSLP.Toolkits.Common;
using System.Security.Cryptography.X509Certificates;
using System.Xml;
namespace com.upay
{
    public class Rsa
    {
        /// <summary>
        /// JAVA公钥转换c#公钥
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static string RSAPublicKeyJava2DotNet(string publicKey)
        {
            RsaKeyParameters publicKeyParam = (RsaKeyParameters)PublicKeyFactory.CreateKey(Convert.FromBase64String(publicKey));
            return string.Format("<RSAKeyValue><Modulus>{0}</Modulus><Exponent>{1}</Exponent></RSAKeyValue>",
                Convert.ToBase64String(publicKeyParam.Modulus.ToByteArrayUnsigned()),
                Convert.ToBase64String(publicKeyParam.Exponent.ToByteArrayUnsigned()));
        }

        /// <summary>
        /// JAVA私钥转换c#私钥
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static string RSAPrivateKeyJava2DotNet(string privateKey)
        {
            RsaPrivateCrtKeyParameters privateKeyParam = (RsaPrivateCrtKeyParameters)PrivateKeyFactory.CreateKey(Convert.FromBase64String(privateKey));

            return string.Format("<RSAKeyValue><Modulus>{0}</Modulus><Exponent>{1}</Exponent><P>{2}</P><Q>{3}</Q><DP>{4}</DP><DQ>{5}</DQ><InverseQ>{6}</InverseQ><D>{7}</D></RSAKeyValue>",
                Convert.ToBase64String(privateKeyParam.Modulus.ToByteArrayUnsigned()),
                Convert.ToBase64String(privateKeyParam.PublicExponent.ToByteArrayUnsigned()),
                Convert.ToBase64String(privateKeyParam.P.ToByteArrayUnsigned()),
                Convert.ToBase64String(privateKeyParam.Q.ToByteArrayUnsigned()),
                Convert.ToBase64String(privateKeyParam.DP.ToByteArrayUnsigned()),
                Convert.ToBase64String(privateKeyParam.DQ.ToByteArrayUnsigned()),
                Convert.ToBase64String(privateKeyParam.QInv.ToByteArrayUnsigned()),
                Convert.ToBase64String(privateKeyParam.Exponent.ToByteArrayUnsigned()));
        }
        /// <summary>
        /// RSA公钥加密
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static string RSAEncrypt(string publickey, string content)
        {

            //string publickey1 = RSAPublicKeyJava2DotNet(publickey);
            RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
            byte[] cipherbytes;
            rsa.FromXmlString(publickey);
            cipherbytes = rsa.Encrypt(Encoding.UTF8.GetBytes(content), false);

            return Convert.ToBase64String(cipherbytes);
        }

        /// <summary>
        /// RSA私钥解密
        /// </summary>
        /// <param name="privatekey"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static string RSADecrypt(string privatekey, string content)
        {

            //string privatekey1 = RSAPrivateKeyJava2DotNet(privatekey);
            RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
            byte[] cipherbytes;
            rsa.FromXmlString(privatekey);
            cipherbytes = rsa.Decrypt(Convert.FromBase64String(content), false);

            return Encoding.UTF8.GetString(cipherbytes);
        }


        /// <summary>
        /// RSA公钥解密
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>

        public static string DecryptString(string encryptString, string key)
        {
            
            string result;
            //公钥解密
           
            //dataByte = Convert.FromBase64String(data);//Convert.FromBase64String(str);         

            result = RSAHelper.DecryptPublicKeyJava(key, encryptString);
            result = result.Substring(result.Length - 16, 16);
            return result;
        }

        /// <summary>
        /// RSA私钥签名
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>

      
        public static string SignatureFormatter(string strPrivateKey, string strContent)
        {
            byte[] btContent = Encoding.UTF8.GetBytes(strContent);
            byte[] hv = MD5.Create().ComputeHash(btContent);
            RSACryptoServiceProvider rsp = new RSACryptoServiceProvider();
            rsp.FromXmlString(strPrivateKey);
            RSAPKCS1SignatureFormatter rf = new RSAPKCS1SignatureFormatter(rsp);
            rf.SetHashAlgorithm("MD5");
            byte[] signature = rf.CreateSignature(hv);
            return Convert.ToBase64String(signature);
        }

        /// <summary>
        /// RSA公钥验签
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>

        public static bool VerifySign(string data, string publicKeyPath, string sign)
        {
            byte[] messagebytes = Convert.FromBase64String(data);
            byte[] messagesign = Convert.FromBase64String(sign);
            X509Certificate2 x509 = new X509Certificate2(publicKeyPath);

            RSACryptoServiceProvider oRSA = new RSACryptoServiceProvider();
            oRSA.FromXmlString(x509.PublicKey.Key.ToXmlString(false));

            bool bVerify = oRSA.VerifyData(messagebytes, "MD5", messagesign);

            return bVerify;
        }

        /// <summary>
        /// RSA公钥加密
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>

        public static string CFCAencryption(string publicKeyPath, string data){
            X509Certificate2 pubcrt = new X509Certificate2(publicKeyPath);
            string keyPublic2 = pubcrt.PublicKey.Key.ToXmlString(false);
           // //解析XML
           // XmlDocument doc = new XmlDocument();
           // doc.LoadXml(keyPublic2);
           // string PubKey = doc.SelectSingleNode("RSAKeyValue/Modulus").InnerText;
            string rsadata = RSAEncrypt(keyPublic2, data);
            return rsadata;

            }

        /// <summary>
        /// RSA私钥解密
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        /// 
        public static string CFCADencryption(string prviateKeyPath, string data, string pfxPassword)
        {
            X509Certificate2 pubcrt = new X509Certificate2(prviateKeyPath, pfxPassword, X509KeyStorageFlags.Exportable | X509KeyStorageFlags.PersistKeySet);
            string keyprivate = pubcrt.PrivateKey.ToXmlString(true);

            string rsadata = RSADecrypt(keyprivate, data);
            return rsadata;

        }

        /// <summary>
        /// RSA私钥签名
        /// </summary>
        /// <param name="publickey"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        /// 
        public static string privateSign(string privateKeyPath,string data ,string pfxPassword)    
        { 
          //    X509Certificate2 pubcrt = new X509Certificate2(privateKeyPath, pfxPassword, X509KeyStorageFlags.Exportable | X509KeyStorageFlags.PersistKeySet);
          //  string keyprivate = pubcrt.PrivateKey.ToXmlString(true);
          //
          //  string sign = SignatureFormatter(keyprivate, data);
          //  return sign;

            X509Certificate2 objx5092;
            if (string.IsNullOrWhiteSpace(pfxPassword))
            {
                objx5092 = new X509Certificate2(privateKeyPath);
            }
            else
            {
                objx5092 = new X509Certificate2(privateKeyPath, pfxPassword);
            }
            RSACryptoServiceProvider rsa = objx5092.PrivateKey as RSACryptoServiceProvider;
            byte[] dataencod = Convert.FromBase64String(data);
            byte[] reslut = rsa.SignData(dataencod, "MD5");//为证书采用MD5withRSA 签名
            return Convert.ToBase64String(reslut);
    }

    }
}
