﻿using System.Text;
using com.upay.utils;
using com.upay.upayException;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace com.upay.OnlinePay
{
    public class UnBindCardBack : ResponseObject
    {
        public UnBindCardBack()
        {
        }

        public UnBindCardBack(string responsestr)
        {
            UnBindCardBack back = JsonConvert.DeserializeObject<UnBindCardBack>(responsestr);
          
            Hmac = back.Hmac;
            MerchantId = back.MerchantId;
            MerchantUserId = back.MerchantUserId;
            BankCardNumber = back.BankCardNumber;
            Status = back.Status;
            Name = back.Name;
            BindCardId = back.BindCardId;
            BindStatus = back.BindStatus;
        }

        /// <summary>
        /// 商户Id
        /// </summary>
        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }

        /// <summary>
        /// 商户会员id
        /// </summary>
        [JsonProperty(PropertyName = "merchantUserId")]
        public string MerchantUserId { get; set; }

        /// <summary>
        /// 银⾏卡号
        /// </summary>
        [JsonProperty(PropertyName = "bankCardNumber")]
        public string BankCardNumber { get; set; }


        /// <summary>
        /// 持卡人姓名
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// 绑卡id
        /// </summary>
        [JsonProperty(PropertyName = "bindCardId")]
        public string BindCardId { get; set; }

        /// <summary>
        /// 银⾏卡绑定状态
        /// </summary>
        [JsonProperty(PropertyName = "bindStatus")]
        public string BindStatus { get; set; }

     
    }
}
