﻿using System.Text;
using com.upay.utils;
using com.upay.upayException;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace com.upay.OnlinePay
{
    public class OnlinePayOrderBack : ResponseObject
    {
        public OnlinePayOrderBack()
        {
        }

        public OnlinePayOrderBack(string responsestr)
        {
            OnlinePayOrderBack back = JsonConvert.DeserializeObject<OnlinePayOrderBack>(responsestr);
          
            Hmac = back.Hmac;
            MerchantId = back.MerchantId;
            ScanCode = back.ScanCode;
            RequestId = back.RequestId;
            Status = back.Status; 
            RedirectUrl = back.RedirectUrl;
            AppParams = back.AppParams;
        }

        /// <summary>
        /// 商户Id
        /// </summary>
        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }

        /// <summary>
        /// 重定向地址
        /// </summary>
        [JsonProperty(PropertyName = "redirectUrl")]
        public string RedirectUrl { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        [JsonProperty(PropertyName = "requestId")]
        public string RequestId { get; set; }


        /// <summary>
        /// base64格式二维码
        /// </summary>
        [JsonProperty(PropertyName = "scanCode")]
        public string ScanCode { get; set; }

        /// <summary>
        /// App调用码
        /// </summary>
        [JsonProperty(PropertyName = "appParams")]
        public string AppParams { get; set; }
        
    }
}
