﻿using System;
using System.Collections.Generic;
using System.Text;
using com.upay.utils;
using com.upay.upayException;
using com.upay.Entity;
using com.upay;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;

namespace com.upay.OnlinePay
{
    public class BindCardQueryBack : ResponseObject
    {
        public BindCardQueryBack()
        {
        }

        public BindCardQueryBack(string responsestr)
            : base(responsestr)
        {
            BindCardQueryBack back = JsonConvert.DeserializeObject<BindCardQueryBack>(responsestr);



            Hmac = back.Hmac;
            MerchantId = back.MerchantId;
            MerchantUserId = back.MerchantUserId;
            BankCardNumber = back.BankCardNumber;
            Status = back.Status;
            Name = back.Name;
            BindCardId = back.BindCardId;
            BindStatus = back.BindStatus;
            CardType = back.CardType;
            BankCode = back.BankCode;
        }

        /// <summary>
        /// 商户Id
        /// </summary>
        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }

        /// <summary>
        /// 商户会员id
        /// </summary>
        [JsonProperty(PropertyName = "merchantUserId")]
        public string MerchantUserId { get; set; }

        /// <summary>
        /// 银⾏卡号
        /// </summary>
        [JsonProperty(PropertyName = "bankCardNumber")]
        public string BankCardNumber { get; set; }


        /// <summary>
        /// 持卡人姓名
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// 绑卡id
        /// </summary>
        [JsonProperty(PropertyName = "bindCardId")]
        public string BindCardId { get; set; }

        /// <summary>
        /// 银⾏卡绑定状态
        /// </summary>
        [JsonProperty(PropertyName = "bindStatus")]
        public string BindStatus { get; set; }

        /// <summary>
        /// 银⾏卡类型
        /// </summary>
        [JsonProperty(PropertyName = "cardType")]
        public string CardType { get; set; }

        /// <summary>
        /// 银⾏编码
        /// </summary>
        [JsonProperty(PropertyName = "bankCode")]
        public string BankCode { get; set; }
        
      
    }
}
