﻿<%@ WebHandler Language="C#" Class="RefundQueryRequest" %>

using System;
using System.Configuration;
using System.Web;
using System.Text;
using com.upay.upayException;
using com.upay.OnlinePay;
using com.upay.Web;
using Newtonsoft.Json.Linq;
using com.upay;
public class RefundQueryRequest : BaseRequest
{
    public override void OnProcessRequest(HttpContext context)
    {
     
        string url = ConfigurationManager.AppSettings["onlinePayRefundQueryUrl"];
        string privatepfxpath = HttpContext.Current.Server.MapPath("../../package/client.pfx");
        String pfxPassword = "123456";
        string publiccrepath = HttpContext.Current.Server.MapPath("../../package/server.cer");
        string aesKeyValue = com.upay.Aes.GenerateRandomNumber(16);
        
        OnlineRefundQuery query = new OnlineRefundQuery();

        query.MerchantId = context.Request.Form["merchantId"];
        query.RequestId = context.Request.Form["requestId"];

        var a = JObject.Parse(query.Json); //将 a 中的 json 解码
        string hm = string.Join("", GetValue.Getvalue1(a));
        string SHA1hmac = SHA1.EncryptToSHA1(hm.ToString());
        string hmac = Rsa.privateSign(privatepfxpath, SHA1hmac, pfxPassword);
        query.Hmac = hmac;
        StringBuilder sbHmac = new StringBuilder();
        sbHmac.Append(hm);
        sbHmac.Append(hmac);
        sbHmac.Append("#");

        string encryptKey = Rsa.CFCAencryption(publiccrepath, aesKeyValue);
        string merchantId = context.Request.Form["merchantId"];
        string requestId = context.Request.Form["requestId"];


        string data = Aes.Encrypt(query.Json.ToString(), aesKeyValue);


        HttpClient client = new HttpClient(url, merchantId, encryptKey, requestId);
        string responsestr = client.Post(data.ToString(), privatepfxpath, pfxPassword);

        JObject jo = JObject.Parse(responsestr);
        jo.Remove("hmac");//去除返回json中的hmac

        var b = JObject.Parse(jo.ToString()); //将 a 中的 json 解码
        string json = string.Join("", GetValue.Getvalue1(b));
        string SHA1H = SHA1.EncryptToSHA1(json.ToString());//根据返回参数摘要出SHA1
       
        
        OnlineRefundQueryBack back = new OnlineRefundQueryBack(responsestr);

        Boolean bo = Rsa.VerifySign(SHA1H, publiccrepath, back.Hmac);

        if (bo == false) throw new HmacVerifyException(responsestr);//确认签名结果

        if (back.Status == "SUCCESS")
        {
            context.Response.Clear();
            context.Response.Write("处理成功！<br/>");
            context.Response.Write(responsestr);
        }
        else if (back.Status == "FAILED")
        {
            context.Response.Clear();
            context.Response.Write("处理失败！<br/>");
            context.Response.Write(responsestr);
        }
        else if (back.Status == "INIT")
        {
            context.Response.Clear();
            context.Response.Write("待处理！<br/>");
            context.Response.Write(responsestr);
        }
        else
        {
            throw new ResponseException(responsestr);
        }
    }
}