﻿<%@ WebHandler Language="C#" Class="BindCardNotify" %>

using System;
using System.Configuration;
using System.IO;
using System.Web;
using com.upay.upayException;
using System.Net;
using com.upay.OnlinePay;
using Newtonsoft.Json.Linq;
using com.upay;
public class BindCardNotify : BaseRequest
{

    public override void OnProcessRequest(HttpContext context)
    {
        string privatepfxpath = HttpContext.Current.Server.MapPath("../../package/client.pfx");
        String pfxPassword = "123456";
        string publiccrepath = HttpContext.Current.Server.MapPath("../../package/server.cer");
      
        Stream postData = context.Request.InputStream;
        StreamReader sRead = new StreamReader(postData);
        HttpRequest response = context.Request;
        string postContent = sRead.ReadToEnd();
        var aeskey = response.Headers["encryptKey"];
        sRead.Close();

        OnlinePayBack datad = new OnlinePayBack(postContent);
        string aeskey1 = Rsa.CFCADencryption(privatepfxpath, aeskey, pfxPassword);
        postContent = com.upay.Aes.Decrypt(datad.Data, aeskey1);

        JObject jo = JObject.Parse(postContent);
        jo.Remove("hmac");//去除返回json中的hmac

        var b = JObject.Parse(jo.ToString()); //将 a 中的 json 解码
        string json = string.Join("", GetValue.Getvalue1(b));
        string Hmac = SHA1.EncryptToSHA1(json.ToString());//根据返回参数摘要出SHA1

        BindCardQueryBack back = new BindCardQueryBack(postContent);

        Boolean bo = Rsa.VerifySign(Hmac, publiccrepath, back.Hmac);

        if (bo == false) throw new HmacVerifyException(postContent);//确认签名结果
        if (back.BindStatus == "SUCCESS")
        {
            context.Response.Clear();
            context.Response.Write("SUCCESS<br/>");
            context.Response.Write("处理成功！<br/>");
            context.Response.Write(postContent);
        }
       
     
        else
        {
            throw new ResponseException(postContent);
        }
    }

}