﻿using System;
using System.IO;
using System.Net;
using System.Text;
using com.upay.upayException;
using Newtonsoft.Json;
using com.upay;
using com.upay.OnlinePay;
namespace com.upay.Web
{
    public class HttpClient
    {
        private readonly HttpWebRequest _request;

        public HttpClient(string url,string cntentType)
        {
            //ServicePointManager.ServerCertificateValidationCallback += (s, cert, chain, sslPolicyErrors) => true;
            //ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls;
            _request = (HttpWebRequest)WebRequest.Create(url);
            _request.ContentType = cntentType;
            _request.Method = "POST";
            _request.Timeout = 300000;
        }

        public HttpClient(string url, string merchantId, string encryptKey,string requestId)
        {
            //ServicePointManager.ServerCertificateValidationCallback += (s, cert, chain, sslPolicyErrors) => true;
            //ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls;
            _request = (HttpWebRequest)WebRequest.Create(url);
            _request.ContentType = "application/vnd.5upay-v3.0+json";
            _request.Headers.Add("encryptKey", encryptKey);
            _request.Headers.Add("merchantId", merchantId);
            _request.Headers.Add("requestId", requestId);
            _request.Method = "POST";
            _request.Timeout = 300000;
        }

        public string Post(string data, string privatepfxpath, string pfxPassword)
        {
            byte[] param = Encoding.GetEncoding("UTF-8").GetBytes(data);

            //写入请求流
            Stream requestStream = _request.GetRequestStream();
            requestStream.Write(param, 0, param.Length);
            requestStream.Close();

            HttpWebResponse response = (HttpWebResponse)_request.GetResponse();

            StringBuilder returnValue = new StringBuilder();
            string ret = "";
            try
            {
                //创建流对象，读取响应流，生成字符串
                StreamReader sr = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding("UTF-8"));
                returnValue.Append(sr.ReadToEnd());
                string merchant = response.Headers["encryptKey"];
                if (String.IsNullOrEmpty(merchant))
                 {
                     throw new ResponseException(returnValue.ToString());
                 }
                 else
                 {
                     string respon = response.Headers["encryptKey"];
                    //RSA私钥解密
                     string aeskey = Rsa.CFCADencryption(privatepfxpath, respon, pfxPassword);

                     //HttpResponse res = new HttpResponse(respon.GetValues(2).ToString());
                     //string key = res.EncryptKey;
                     OnlinePayBack back = new OnlinePayBack(returnValue.ToString());
                     string value = back.Data;

                     ret = Aes.Decrypt(value, aeskey);
                 }
            }
            catch (Exception ex)
            {
                throw new UnknownException(ex.Message, ex);
            }
            finally
            {
                //关闭响应流
                response.Close();
            }

            return ret;
        }
    }
}
