﻿using System.Text;
using com.upay.utils;
using com.upay.upayException;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace com.upay.OnlinePay
{
    public class ReceiptPaymentBack : ResponseObject
    {
        public ReceiptPaymentBack()
        {
        }

        public ReceiptPaymentBack(string responsestr)
        {
            ReceiptPaymentBack back = JsonConvert.DeserializeObject<ReceiptPaymentBack>(responsestr);
          
            Hmac = back.Hmac;
            MerchantId = back.MerchantId;
            RequestId = back.RequestId;
            PaymentOrderId = back.PaymentOrderId;
            ErrorMessage = back.ErrorMessage;
            Status = back.Status;
          
        }

        /// <summary>
        /// 商户Id
        /// </summary>
        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        [JsonProperty(PropertyName = "requestId")]
        public string RequestId { get; set; }

        /// <summary>
        /// 收款订单id
        /// </summary>
        [JsonProperty(PropertyName = "paymentOrderId")]
        public string PaymentOrderId { get; set; }


        /// <summary>
        /// 错误信息
        /// </summary>
        [JsonProperty(PropertyName = "errorMessage")]
        public string ErrorMessage { get; set; }

     

     
    }
}
