﻿using System.Text;
using com.upay.utils;
using com.upay.upayException;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace com.upay.OnlinePay
{
    public class OnlineRefundQueryBack : ResponseObject
    {
        public OnlineRefundQueryBack()
        {
            
        }

        public OnlineRefundQueryBack(string responsestr)
            : base(responsestr)
        {
            OnlineRefundQueryBack back = JsonConvert.DeserializeObject<OnlineRefundQueryBack>(responsestr);

         

            MerchantId = back.MerchantId;
            RequestId = back.RequestId;
            SerialNumber = back.SerialNumber;
            OrderId = back.OrderId;
            Status = back.Status;
            SerialNumber = back.MerchantId;
            ErrorMessage = back.ErrorMessage;
            Amount = back.Amount;
            Currency = back.Currency;
            CompleteDateTime = back.CompleteDateTime;
            Hmac = back.Hmac;
        }

        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }

        [JsonProperty(PropertyName = "requestId")]
        public string RequestId { get; set; }

        [JsonProperty(PropertyName = "serialNumber")]
        public string SerialNumber { get; set; }

        [JsonProperty(PropertyName = "orderId")]
        public string OrderId { get; set; }

        [JsonProperty(PropertyName = "errorMessage")]
        public string ErrorMessage { get; set; }

        [JsonProperty(PropertyName = "errorCode")]
        public string ErrorCode { get; set; }

        [JsonProperty(PropertyName = "amount")]
        public string Amount { get; set; }

        [JsonProperty(PropertyName = "currency")]
        public string Currency { get; set; }

        [JsonProperty(PropertyName = "completeDateTime")]
        public string CompleteDateTime { get; set; }
    }
}
