﻿using System;
using System.Collections.Generic;
using System.Text;
using com.upay.utils;
using com.upay.upayException;
using com.upay.Entity;
using com.upay;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;

namespace com.upay.OnlinePay
{
    public class OnlinePayQueryBack : ResponseObject
    {
        public OnlinePayQueryBack()
        {
        }

        public OnlinePayQueryBack(string responsestr)
            : base(responsestr)
        {
            OnlinePayQueryBack back = JsonConvert.DeserializeObject<OnlinePayQueryBack>(responsestr);
        

          

            MerchantId = back.MerchantId;
            RequestId = back.RequestId;
            SerialNumber = back.SerialNumber;
            TotalRefundCount = back.TotalRefundCount;
            TotalRefundAmount = back.TotalRefundAmount;
            OrderCurrency = back.OrderCurrency;
            OrderAmount = back.OrderAmount;
            CompleteDateTime = back.CompleteDateTime;
            Remark = back.Remark;
            Status = back.Status;
            Hmac = back.Hmac;
        }

        /// <summary>
        /// 商家ID
        /// </summary>
        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        [JsonProperty(PropertyName = "requestId")]
        public string RequestId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty(PropertyName = "serialNumber")]
        public string SerialNumber { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty(PropertyName = "totalRefundCount")]
        public string TotalRefundCount { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty(PropertyName = "totalRefundAmount")]
        public string TotalRefundAmount { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty(PropertyName = "orderCurrency")]
        public string OrderCurrency { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty(PropertyName = "orderAmount")]
        public string OrderAmount { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty(PropertyName = "completeDateTime")]
        public string CompleteDateTime { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty(PropertyName = "remark")]
     
        public string Remark { get; set; }

      
    }
}
