﻿using System.Text;
using com.upay.utils;
using com.upay.upayException;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace com.upay.OnlinePay
{
    public class BindCardConfirmBack : ResponseObject
    {
        public BindCardConfirmBack()
        {
        }

        public BindCardConfirmBack(string responsestr)
        {
            BindCardConfirmBack back = JsonConvert.DeserializeObject<BindCardConfirmBack>(responsestr);
          
            Hmac = back.Hmac;
            MerchantId = back.MerchantId;
            MerchantUserId = back.MerchantUserId;
            BindCardId = back.BindCardId;
            Status = back.Status;
            BindStatus = back.BindStatus;
        }

        /// <summary>
        /// 商户Id
        /// </summary>
        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }

        /// <summary>
        /// 商户会员id
        /// </summary>
        [JsonProperty(PropertyName = "merchantUserId")]
        public string MerchantUserId { get; set; }

        /// <summary>
        /// 银⾏卡号
        /// </summary>
        [JsonProperty(PropertyName = "bindCardId")]
        public string BindCardId { get; set; }


        /// <summary>
        /// 银⾏卡绑定状态
        /// </summary>
        [JsonProperty(PropertyName = "bindStatus")]
        public string BindStatus { get; set; }

        
        
    }
}
