﻿<%@ WebHandler Language="C#" Class="BindCardRequest" %>

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Net;
using com.upay.upayException;
using com.upay.Entity;
using System.IO;
using com.upay.OnlinePay;
using com.upay.Web;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.Drawing;
using System.Runtime.Serialization.Json;
using System.Linq;
using System.Text;
using com.upay;
using CFCALibraries;
public class BindCardRequest : BaseRequest 
{
    private readonly HttpWebRequest _request;
    public override void OnProcessRequest(HttpContext context)
    {
        string url = ConfigurationManager.AppSettings["bankCardUrl"];
        string privatepfxpath = HttpContext.Current.Server.MapPath("../../package/client.pfx");
        String pfxPassword = "123456";
        string publiccrepath = HttpContext.Current.Server.MapPath("../../package/server.cer");
        
        string aesKeyValue = Aes.GenerateRandomNumber(16);
        BindCardOrder order = new BindCardOrder();
      
        order.MerchantId = context.Request.Form["merchantId"];
        order.MerchantUserId = context.Request.Form["merchantUserId"];
        order.PhoneNumber = context.Request.Form["phoneNumber"];
        order.BankCardNumber = context.Request.Form["bankCardNumber"];
        order.Name = context.Request.Form["name"];
        order.IdCardNum = context.Request.Form["idCardNum"];
        order.ValidTerm = context.Request.Form["validTerm"];
        order.BankCardCvv = context.Request.Form["bankCardCvv"];
       
    
      
        
        var a = JObject.Parse(order.Json); //将 a 中的 json 解码
        string hm = string.Join("", GetValue.Getvalue1(a));
        string SHA1hmac = SHA1.EncryptToSHA1(hm.ToString());
        string hmac = Rsa.privateSign(privatepfxpath, SHA1hmac, pfxPassword);
        order.hmac = hmac;
        StringBuilder sbHmac = new StringBuilder();
        sbHmac.Append(hm);
        sbHmac.Append(hmac);
        sbHmac.Append("#");

        string encryptKey = Rsa.CFCAencryption(publiccrepath,aesKeyValue);
        string merchantId = context.Request.Form["merchantId"];
        string requestId = context.Request.Form["requestId"];
        
        
        string data = Aes.Encrypt(order.Json.ToString(), aesKeyValue);


        HttpClient client = new HttpClient(url, merchantId, encryptKey,requestId);
        string responsestr = client.Post(data.ToString(), privatepfxpath, pfxPassword);

        JObject jo = JObject.Parse(responsestr);
        jo.Remove("hmac");//去除返回json中的hmac

        var b = JObject.Parse(jo.ToString()); //将 a 中的 json 解码
        string json = string.Join("", GetValue.Getvalue1(b));
        string SHA1H = SHA1.EncryptToSHA1(json.ToString());//根据返回参数摘要出SHA1


        BindCardOrderBack back = new BindCardOrderBack(responsestr);
         Boolean bo = Rsa.VerifySign(SHA1H, publiccrepath,back.Hmac);
        
        if (bo==false) throw new HmacVerifyException(responsestr);//确认签名结果
        if  (back.Status == "SUCCESS")
        {
            context.Response.Clear();
            context.Response.Write(responsestr);

        }else if (back.Status == "REDIRECT")
        {
            context.Response.Redirect(back.BindCardRedirectUrl);

        }
        else
        {
            throw new ResponseException(responsestr);
        }
    }


 

  
    
    

}