﻿<%@ WebHandler Language="C#" Class="BindCardQueryRequest" %>

using System;
using System.Web;
using System.Text;
using System.Configuration;
using System.Collections.Generic;
using com.upay.upayException;
using com.upay.OnlinePay;
using com.upay.Web;
using com.upay;
using Newtonsoft.Json.Linq;

public class BindCardQueryRequest : BaseRequest
{
    public override void OnProcessRequest(HttpContext context)
    {
        string url = ConfigurationManager.AppSettings["bankCardQueryUrl"];
        string privatepfxpath = HttpContext.Current.Server.MapPath("../../package/client.pfx");
        String pfxPassword = "123456";
        string publiccrepath = HttpContext.Current.Server.MapPath("../../package/server.cer");
        string aesKeyValue = com.upay.Aes.GenerateRandomNumber(16);
        BindCardQuery bindQuery = new BindCardQuery();

        bindQuery.MerchantId = context.Request.Form["merchantId"];
        bindQuery.MerchantUserId = context.Request.Form["merchantUserId"];
        bindQuery.BindCardId = context.Request.Form["bindCardId"];
        var a = JObject.Parse(bindQuery.Json); //将 a 中的 json 解码
        string hm = string.Join("", GetValue.Getvalue1(a));
        string SHA1hmac = SHA1.EncryptToSHA1(hm.ToString());
        string hmac = Rsa.privateSign(privatepfxpath, SHA1hmac, pfxPassword);
        bindQuery.hmac = hmac;
        StringBuilder sbHmac = new StringBuilder();
        sbHmac.Append(hm);
        sbHmac.Append(hmac);
        sbHmac.Append("#");
        string data = com.upay.Aes.Encrypt(bindQuery.Json.ToString(), aesKeyValue);

        string encryptKey = Rsa.CFCAencryption(publiccrepath, aesKeyValue);
        string merchantId = context.Request.Form["merchantId"];
        string requestId = context.Request.Form["requestId"];
        
        HttpClient client = new HttpClient(url, merchantId, encryptKey,requestId);
        string responsestr = client.Post(data.ToString(), privatepfxpath, pfxPassword);

        JObject jo = JObject.Parse(responsestr);
        jo.Remove("hmac");//去除返回json中的hmac

        var b = JObject.Parse(jo.ToString()); //将 a 中的 json 解码
        string json = string.Join("", GetValue.Getvalue1(b));
        string SHA1H = SHA1.EncryptToSHA1(json.ToString());//根据返回参数摘要出SHA1

        BindCardQueryBack back = new BindCardQueryBack(responsestr);

        Boolean bo = Rsa.VerifySign(SHA1H, publiccrepath, back.Hmac);

        if (bo == false) throw new HmacVerifyException(responsestr);//确认签名结果
        
        if (back.Status == "SUCCESS")
        {
            context.Response.Clear();
            context.Response.Write("处理成功！<br/>");
            context.Response.Write(responsestr);
        }
       
        else
        {
            throw new ResponseException(responsestr);
        }

    }
    
}