
from django.shortcuts import render_to_response
from django.http import HttpResponse
import requests
from hashlib import sha1
import json
import base64
from Crypto import Random
from Crypto.Hash import MD5
from Crypto.PublicKey import RSA
from Crypto.Signature import PKCS1_v1_5 as Signature_pkcs1_v1_5
from Crypto.Cipher import PKCS1_v1_5 as Cipher_pkcs1_v1_5
import os
import random
from Crypto.Cipher import AES
from Crypto.Util.Padding import pad, unpad

from django.http import HttpResponseRedirect
# Create your views here.
def index(request):
    return render_to_response('templates/index.html')

def order(request):
    return render_to_response('templates/order.html')

def query(request):
    return render_to_response('templates/query.html')

def refund(request):
    return render_to_response('templates/refund.html')

def refundQuery(request):
    return render_to_response('templates/refundQuery.html')




#排序
def get_sort(dic):
    dics2 = ''
    dics = dict(sorted(dic.items(),reverse=False))
    
    print("dics-----------------:",dics)
    
    for dics1 in dics :
        
        print(dics1,type(dics[dics1]))
        
        if isinstance(dics[dics1],dict):
        
            dict12 = dics[dics1]
            
            dics2+=get_sort(dict12)

        elif isinstance(dics[dics1],str): 

            if(dics[dics1].strip() !=""):
                
                dics2+=dics[dics1]+'#'
                
        elif type(dics[dics1]).__name__ == "bool": 
            
            str_bool = str(dics[dics1])
            
            str_bool_lower = str_bool.lower()
            
            print("bool---------------------;",str_bool_lower)
            
            dics2+=str_bool_lower+'#'
            
        elif type(dics[dics1]).__name__ == "int": 

            dics2+=str(dics[dics1])+'#'   
            
        elif isinstance(dics[dics1],list):          
            
            dict12 = dics[dics1]
            
            dic_list = {}
            
            for i in range(len(dict12)):
                
                dic_list.setdefault(i, dict12[i])
            
            print("dic_list------------------:",dic_list)
                
            dics2+=get_sort(dic_list)
                
    return dics2     


 
    
#私钥签名
def gen_sign(unsign_data):
   
   
    path = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    doc = os.path.join(path, 'client.pem')
    
    
    with open(doc) as pk:
        key_data = pk.read()
        
    key_data1 =key_data 
    
    private_keyBytes =base64.b64decode(key_data1)
    
    priKey = RSA.importKey(private_keyBytes)
    signer = Signature_pkcs1_v1_5.new(priKey)
    digest = MD5.new(unsign_data)
    
    sign = signer.sign(digest)
    signature = base64.b64encode(sign)
    #signn=base64.urlsafe_b64encode(sign)
    
    #print (signn)
    return signature
#公钥验签
def verify_sign(data, sign):
   
   
    path = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    doc = os.path.join(path, 'server.pem')
    
    
    with open(doc) as pk:
        key_data = pk.read()
        
    key_data1 =key_data 
    
    private_keyBytes =base64.b64decode(key_data1)
    
    priKey = RSA.importKey(private_keyBytes)
    verifier = Signature_pkcs1_v1_5.new(priKey)
    digest = MD5.new(data)
    is_verify = verifier.verify(digest, base64.b64decode(sign))
    #print(is_verify)
    return is_verify

#公钥加密
def gen_encrypt(encrydata):
    
    path = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    doc = os.path.join(path, 'server.pem')
    with open(doc) as pk:
        key_data = pk.read()
        #print(key_data)
        
    key_data1 =key_data 
    #print (key_data1)
    
    private_keyBytes =base64.b64decode(key_data1)
    #print (private_keyBytes)
    
    
    rsakey = RSA.importKey(private_keyBytes)
    cipher = Cipher_pkcs1_v1_5.new(rsakey)
    
    
    cipher_text = base64.b64encode(cipher.encrypt(encrydata.encode()))
    #print (encrydata)
    
    return cipher_text

#私钥解密
def gen_decrypt(encrydata):
    
    path = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    doc = os.path.join(path, 'client.pem')
    with open(doc) as pk:
        key_data = pk.read()
        #print(key_data)
        
    key_data1 =key_data 
    #print (key_data1)
    
    private_keyBytes =base64.b64decode(key_data1)
    #print (private_keyBytes)
    
    
    rsakey = RSA.importKey(private_keyBytes)
    cipher = Cipher_pkcs1_v1_5.new(rsakey)
    
    #print('encrydata:------'+encrydata)
    
    text = cipher.decrypt(base64.b64decode(encrydata.encode()),None)
    return text
  
#获取16位AES随机值
def gen_random():
    raw_pwd=random.sample('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890',16)

    str = ''
    for raw in raw_pwd:
        str +=raw
    return str



PADDING = '\0'
def decrypt_aes(key,cryptedStr):
    generator = AES.new(key, AES.MODE_ECB)
    cryptedStr = base64.b64decode(cryptedStr)
    recovery = generator.decrypt(cryptedStr)
    print(recovery)
    decryptedStr = recovery.rstrip(PADDING.encode('utf-8'))
    return decryptedStr


#AES加密
def aes_cipher(key, aes_str):
    aes = AES.new(key.encode('utf-8'), AES.MODE_ECB)
    pad_pkcs7 = pad(aes_str.encode('utf-8'), AES.block_size, style='pkcs7')  
    encrypt_aes = aes.encrypt(pad_pkcs7)
    encrypted_text = str(base64.encodebytes(encrypt_aes), encoding='utf-8')  
    encrypted_text_str = encrypted_text.replace("\n", "")

    return encrypted_text_str













