﻿using com.upay.exception;
using System.Web;

public class BaseRequest : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        try
        {
            OnProcessRequest(context);
        }
        catch (ResponseException ex)
        {
            context.Response.Clear();
            context.Response.Write("响应异常</br>");
            context.Response.Write(ex.Message);
        }
        catch (HmacVerifyException ex)
        {
            context.Response.Clear();
            context.Response.Write("签名验证异常</br>");
            context.Response.Write(ex.Message);
        }
        catch (UnknownException ex)
        {
            context.Response.Clear();
            context.Response.Write("未知异常</br>");
            context.Response.Write(ex.Message);
        }
    }

    public virtual void OnProcessRequest(HttpContext context)
    {

    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}