﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;


namespace com.upay.response
{
    public class PayResponse : ResponseObject
    {

        public PayResponse() { 
        }

        public PayResponse(string responsestr)
              : base(responsestr)
        {
            PayResponse back = JsonConvert.DeserializeObject<PayResponse>(responsestr);

            Hmac = back.Hmac;
            MerchantId = back.MerchantId;
            RequestId = back.RequestId;
            PartnerId = back.PartnerId;
            Status = back.Status;
            RedirectUrl = back.RedirectUrl;
            ScanCode = back.ScanCode;

        }

        //商户号
        [JsonProperty(PropertyName = "merchantId")]
        public string MerchantId { get; set; }
        //订单号
        [JsonProperty(PropertyName = "requestId")]
        public string RequestId { get; set; }
        //服务商编号
        [JsonProperty(PropertyName = "partnerId")]
        public string PartnerId { get; set; }

        [JsonProperty(PropertyName = "status")]
        public string Status { get; set; }


        [JsonProperty(PropertyName = "scanCode")]
        public string ScanCode { get; set; }
        
        [JsonProperty(PropertyName = "redirectUrl")]
        public string RedirectUrl { get; set; }

        [JsonProperty(PropertyName = "hmac")]
        public string Hmac { get; set; }

    }
}