﻿

using System;
using System.Collections.Generic;

using System.Web;
using com.upay.entity;
using com.upay.exception;
using com.upay.response;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using com.upay;
using System.Text;

namespace onlinepay
{
    //退款查询
    public class RefundQueryRequest : BaseRequest
    {

        public override void OnProcessRequest(HttpContext context)
        {
            //接口地址
            string url = "https://apis.5upay.com/onlinePay/refundQuery";

            //私钥路径
            string pfxPath = HttpContext.Current.Server.MapPath("../cfca/client.pfx");
            string pfxPassword = "123456";//私钥密码
            //公钥路径(不需要更换)
            string cerPath = HttpContext.Current.Server.MapPath("../cfca/server.cer");

            //随机生成十六位AES密钥
            string aesKeyValue = com.upay.Aes.GenerateRandomNumber(16);

            //获取前端参数
            QueryEntity query = new QueryEntity();

            query.MerchantId = context.Request.Form["merchantId"];
            query.RequestId = context.Request.Form["requestId"];
            query.PartnerId = context.Request.Form["partnerId"];
           


            //处理获取的信息加hmac
            var jsonA = JObject.Parse(query.Json);
            string hm = string.Join("", GetValue.Getvalue1(jsonA));
            string SHA1hmac = SHA1.EncryptToSHA1(hm.ToString());
            string hmac = Rsa.privateSign(pfxPath, SHA1hmac, pfxPassword);
            query.Hmac = hmac;
            StringBuilder sbHmac = new StringBuilder();
            sbHmac.Append(hm);
            sbHmac.Append(hmac);
            sbHmac.Append("#");

            //公钥加密AES密钥
            string encryptKey = Rsa.CFCAencryption(cerPath, aesKeyValue);
            //获取商户号 订单号 等信息
            string merchantId = context.Request.Form["merchantId"];
            string requestId = context.Request.Form["requestId"];
            string partnerId = context.Request.Form["partnerId"];

            string data = Aes.Encrypt(query.Json.ToString(), aesKeyValue);

            //请求信息
            HttpClient client = new HttpClient(url, merchantId, encryptKey, requestId, partnerId);
            string responsestr = client.Post(data.ToString(), pfxPath, pfxPassword);

            //去除返回json中的hmac
            JObject jo = JObject.Parse(responsestr);
            jo.Remove("hmac");

            //处理返回数据
            var jsonB = JObject.Parse(jo.ToString());
            string json = string.Join("", GetValue.Getvalue1(jsonB));
            string SHA1H = SHA1.EncryptToSHA1(json.ToString());//根据返回参数摘要出SHA1

            PayResponse back = new PayResponse(responsestr);

            Boolean verify = Rsa.VerifySign(SHA1H, cerPath, back.Hmac);

            //确认签名结果
            if (verify == false) throw new HmacVerifyException(responsestr);
           
           
            //成功
            if (back.Status == "SUCCESS")
            {
                context.Response.Clear();
                context.Response.Write("处理成功！<br/>");
                context.Response.Write(responsestr);
            }
            //失败
            else if (back.Status == "FAILED")
            {
                context.Response.Clear();
                context.Response.Write("处理失败！<br/>");
                context.Response.Write(responsestr);
            }

            //异常
            else
            {
                throw new ResponseException(responsestr);
            }

        }
    }
}