﻿

using System;
using System.Collections.Generic;

using System.Web;
using com.upay.entity;
using com.upay.exception;
using com.upay.response;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using com.upay;
using System.Text;
using System.Drawing;
using System.IO;

namespace onlinepay
{
    //统一收单接口
    public class OrderRequest : BaseRequest
    {

        public override void OnProcessRequest(HttpContext context)
        {
            //接口地址
            string url = "https://apis.5upay.com/onlinePay/order";

            //私钥路径
            string pfxPath = HttpContext.Current.Server.MapPath("../cfca/client.pfx");
            string pfxPassword = "123456";//私钥密码
            //公钥路径(不需要更换)
            string cerPath = HttpContext.Current.Server.MapPath("../cfca/server.cer");

            //随机生成十六位AES密钥
            string aesKeyValue = com.upay.Aes.GenerateRandomNumber(16);

            //获取前端参数
            OrderEntity order = new OrderEntity();

            order.MerchantId = context.Request.Form["merchantId"];
            order.RequestId = context.Request.Form["requestId"];
            order.PartnerId = context.Request.Form["partnerId"];
            order.OrderAmount = context.Request.Form["orderAmount"];
            order.OrderCurrency = context.Request.Form["orderCurrency"];
            order.NotifyUrl = context.Request.Form["notifyUrl"];
            order.CallbackUrl = context.Request.Form["callbackUrl"];
            order.Remark = context.Request.Form["remark"];
            order.PaymentModeCode = context.Request.Form["paymentModeCode"];
            order.AuthCode = context.Request.Form["authCode"];
            order.AppId = context.Request.Form["appId"];
            order.OpenId = context.Request.Form["openId"];
            order.SplitMark = context.Request.Form["splitMark"];
            order.ClientIp = context.Request.Form["clientIp"];
            order.Timeout = context.Request.Form["timeout"];
            order.MerchantUserId = context.Request.Form["merchantUserId"];
            order.BindCardId = context.Request.Form["bindCardId"];
            order.ReportSerialNo = context.Request.Form["reportSerialNo"];
            order.ReportTerminalNo = context.Request.Form["reportTerminalNo"];
            order.LimitAccType = context.Request.Form["limitAccType"];
            order.SubsidyMark = context.Request.Form["subsidyMark"];
            order.SubsidyAmount = context.Request.Form["subsidyAmount"];
            order.NeedOpenLink = context.Request.Form["needOpenLink"];
            //商品信息
            List<ProductDetail> PDS = JsonConvert.DeserializeObject<List<ProductDetail>>(context.Request.Form["productDetail"]);
            order.ProductDetails = PDS;

            //身份信息
            Payer payer = new Payer();
            payer.Name = context.Request.Form["payerName"];
            payer.PhoneNum = context.Request.Form["phoneNum"];
            payer.IdType = context.Request.Form["idType"];
            payer.IdNum = context.Request.Form["idNum"];
            payer.BankCardNum = context.Request.Form["bankCardNum"];
            payer.Email = context.Request.Form["email"];
            order.Payer = payer;


            //处理获取的信息加hmac
            var jsonA = JObject.Parse(order.Json);
            string hm = string.Join("", GetValue.Getvalue1(jsonA));
            string SHA1hmac = SHA1.EncryptToSHA1(hm.ToString());
            string hmac = Rsa.privateSign(pfxPath, SHA1hmac, pfxPassword);
            order.Hmac = hmac;
            StringBuilder sbHmac = new StringBuilder();
            sbHmac.Append(hm);
            sbHmac.Append(hmac);
            sbHmac.Append("#");

            //公钥加密AES密钥
            string encryptKey = Rsa.CFCAencryption(cerPath, aesKeyValue);
            //获取商户号 订单号 等信息
            string merchantId = context.Request.Form["merchantId"];
            string requestId = context.Request.Form["requestId"];
            string partnerId = context.Request.Form["partnerId"];

            string data = Aes.Encrypt(order.Json.ToString(), aesKeyValue);

            //请求信息
            HttpClient client = new HttpClient(url, merchantId, encryptKey, requestId, partnerId);
            string responsestr = client.Post(data.ToString(), pfxPath, pfxPassword);

            //去除返回json中的hmac
            JObject jo = JObject.Parse(responsestr);
            jo.Remove("hmac");

            //处理返回数据
            var jsonB = JObject.Parse(jo.ToString());
            string json = string.Join("", GetValue.Getvalue1(jsonB));
            string SHA1H = SHA1.EncryptToSHA1(json.ToString());//根据返回参数摘要出SHA1

            PayResponse back = new PayResponse(responsestr);

            Boolean verify = Rsa.VerifySign(SHA1H, cerPath, back.Hmac);

            //确认签名结果
            if (verify == false) throw new HmacVerifyException(responsestr);
            //重定向收银台页面
            if (back.Status == "REDIRECT")
            {
                context.Response.Redirect(back.RedirectUrl);
            }
            //成功
            else if (back.Status == "SUCCESS")
            {
                context.Response.Clear();
                context.Response.Write("处理成功！<br/>");
                context.Response.Write(responsestr);
            }
            //失败
            else if (back.Status == "FAILED")
            {
                context.Response.Clear();
                context.Response.Write("处理失败！<br/>");
                context.Response.Write(responsestr);
            }

            //异常
            else
            {
                throw new ResponseException(responsestr);
            }

        }
    }
}