/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto;

import com.upay.sdk.crypto.sm.crypto.ECKeyUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class BCUtil {
    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    public static ECPrivateKeyParameters toSm2Params(String d) {
        return ECKeyUtil.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toSm2Params(byte[] d) {
        return ECKeyUtil.toSm2PrivateParams(d);
    }

    public static ECPublicKeyParameters toSm2Params(String xHex, String yHex) {
        return ECKeyUtil.toSm2PublicParams(xHex, yHex);
    }

    public static ECPublicKeyParameters toSm2Params(byte[] xBytes, byte[] yBytes) {
        return ECKeyUtil.toSm2PublicParams(xBytes, yBytes);
    }

    public static ECPublicKeyParameters toParams(PublicKey publicKey) {
        return ECKeyUtil.toPublicParams(publicKey);
    }

    public static ECPrivateKeyParameters toParams(PrivateKey privateKey) {
        return ECKeyUtil.toPrivateParams(privateKey);
    }
}

