/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.international.spi;

import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.crypto.EncryptionAlgorithm;
import com.upay.sdk.crypto.SdkEncryptDecryptSupport;
import com.upay.sdk.crypto.international.utils.AESUtils;
import com.upay.sdk.crypto.international.utils.RSAUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class InternationalAlgorithmSupportImpl
implements SdkEncryptDecryptSupport {
    public String getContentType() {
        return ConfigurationUtils.getHttpContentTypeV3();
    }

    public boolean isSupport(EncryptionAlgorithm encryptionAlgorithm) {
        return encryptionAlgorithm == EncryptionAlgorithm.INTERNATIONAL_ALGORITHM;
    }

    public byte[] digest(byte[] data) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            sha.update(data);
            return sha.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String sign(byte[] data, String privateKeyBase64Str) {
        try {
            return RSAUtils.sign(data, privateKeyBase64Str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verify(byte[] data, String publicKey, String sign) {
        try {
            return RSAUtils.verify(data, publicKey, sign);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String symmetricEncrypt(String data, String key) {
        return AESUtils.encryptToBase64(data, key);
    }

    public String symmetricDecrypt(String data, String key) {
        return AESUtils.decryptFromBase64(data, key);
    }

    public String asymmetricEncrypt(String data, String publicKeyBase64Str) {
        try {
            return RSAUtils.encryptByPublicKey(data, publicKeyBase64Str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String asymmetricDecrypt(String data, String privateKeyBase64Str) {
        try {
            return RSAUtils.decryptByPrivateKey(data, privateKeyBase64Str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

