/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transferaccount.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.transferaccount.builder.GenerateSubTransferVoucherBuilder;
import com.upay.sdk.transferaccount.builder.GenerateTransferVoucherBuilder;
import com.upay.sdk.transferaccount.builder.OrderBuilder;
import com.upay.sdk.transferaccount.builder.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferAccountOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(TransferAccountOrderExecuter.class);

    public void bothOrder(OrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferAccountOrderExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],transferAccountOrderUrl:[" + ConfigurationUtils.getTransferAccountOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferAccountOrderUrl(), requestData);
        LOGGER.debug("TransferAccountOrderExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothQuery(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("TransferAccountOrderExecuter queryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferAccountQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferAccountOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        LOGGER.info("TransferAccountOrderExecuter bothCipherCallback responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("TransferAccountOrderExecuter bothCipherCallback data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        LOGGER.info("TransferAccountOrderExecuter bothCipherCallback status:[" + status + "]");
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("PROCESSING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void bothGenerateTransferVoucher(GenerateTransferVoucherBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("TransferAccountOrderExecuter generateTransferVoucherV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferAccountGenerateTransferVoucherUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("TransferAccountOrderExecuter generateTransferVoucherV_3 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferAccountOrderExecuter generateTransferVoucherV_3 responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothGenerateSubTransferVoucher(GenerateSubTransferVoucherBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("TransferAccountOrderExecuter generateSubTransferVoucherV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferAccountGenerateSubTransferVoucherUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("TransferAccountOrderExecuter generateSubTransferVoucherV_3 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferAccountOrderExecuter generateSubTransferVoucherV_3 responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

