/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class OpenAccountIntendConfirmApplyBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String reportRequestId;
    private String applyTimeout;
    private String notifyUrl;
    private String name;
    private String mobile;
    private String idCardNumber;
    private String microBizType;
    private String storeName;
    private String storeHeaderCopy;
    private String storeIndoorCopy;
    private String channelType;

    public OpenAccountIntendConfirmApplyBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getReportRequestId() {
        return this.reportRequestId;
    }

    public String getApplyTimeout() {
        return this.applyTimeout;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getMicroBizType() {
        return this.microBizType;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getStoreHeaderCopy() {
        return this.storeHeaderCopy;
    }

    public String getStoreIndoorCopy() {
        return this.storeIndoorCopy;
    }

    public String getName() {
        return this.name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getIdCardNumber() {
        return this.idCardNumber;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public OpenAccountIntendConfirmApplyBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setReportRequestId(String reportRequestId) {
        this.reportRequestId = reportRequestId;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setApplyTimeout(String applyTimeout) {
        this.applyTimeout = applyTimeout;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setMicroBizType(String microBizType) {
        this.microBizType = microBizType;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setStoreHeaderCopy(String storeHeaderCopy) {
        this.storeHeaderCopy = storeHeaderCopy;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setStoreIndoorCopy(String storeIndoorCopy) {
        this.storeIndoorCopy = storeIndoorCopy;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber;
        return this;
    }

    public OpenAccountIntendConfirmApplyBuilder setChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }
}

