/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepay.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.PrepayConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepayDestroyOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(PrepayDestroyOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS, Constants.SERIAL_NUMBER, "cardNo"};

    public void order(JSONObject requestData, ResultListener resultListener) throws Exception {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "],destroyOrderUrl:[" + ConfigurationUtils.getDestroyOrderUrl() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getDestroyOrderUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
        String cardNo = (String)responseData.get((Object)"cardNo");
        String merchantId = (String)responseData.get((Object)"merchantId");
        String decrepCardNo = RSAUtils.decreptData(cardNo, PrepayConfigurationUtils.getPrivateKey(merchantId));
        responseData.put("cardNo", (Object)decrepCardNo);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

